/**
 * 国家励志奖学金
 * 钟是志
 * 2019年11月28日
 * 因业务复杂只能特殊开发
 * */
import React, { Component } from 'react';
import ApplyPage from '../index';
import { getDefaultValues } from '../../destruction';
import { message } from 'antd';

const getIndex = (arr, name) => {
	return arr.findIndex((x) => {
		return x.name === name;
	});
};

const GJLZJXJApply = (WrappedComponent) =>
	class extends Component {
		diyFunction = () => {
			this.instanceComponent.handleButtonSet = () => {
				let that = this.instanceComponent;
				const { addFields, workId, tableInfo } = that.state;
				const bankNumIndex = getIndex(addFields, '银行卡号');
				const defaultValues = getDefaultValues(addFields, tableInfo);
				const beforeSubmit = (data, ModalFormComponent) => {
					const bankKey = addFields[bankNumIndex].key;
					if (data[bankKey] && data[bankKey].replace(/\s/g, '').length !== 19) {
						message.warning('请输入正确的19位银行卡卡号');
						return false;
					}
					return data;
				};
				return [
					{
						type: 'add',
						name: '申请',
						component: 'ModalForm',
						workId,
						fields: addFields,
						modalWidth: 800,
						values: {
							...defaultValues,
						},
						beforeSubmit,
						nameSpan: { big: 6, small: 6 },
						fileSpan: { big: 1, small: 1 },
					},
				];
			};
		};

		componentDidMount() {
			this.diyFunction();
		}

		render() {
			return (
				<WrappedComponent
					ref={(instanceComponent) => (this.instanceComponent = instanceComponent)}
				/>
			);
		}
	};
export default KNXSRDApply(ApplyPage); // 高阶组件
