import { getIsBei_Dian } from '@/webPublic/zyd_public/utils/getSchoolType';
import { message, Modal } from 'antd';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';

export default function rebackButton(serviceInfo){
  let reBack = [];
  if (getIsBei_Dian() && serviceInfo?.isCanRecall) { // 撤销按钮
    reBack.push({
      type: 'chehui',
      name: '撤回',
      buttonType: 'danger',
      component: 'Normal',
      handleClick: (selectRows, formValues, getPage, search, columns) => {
        if (!selectRows || !selectRows.length || selectRows.length !== 1) {
          message.warning('请选择一条需要撤回的数据！');
          return false;
        }
        if (!selectRows[0].isBack) {
          message.warning('当前流程无法撤回，请选择其他数据');
          return false;
        }
        Modal.confirm({
          title: '撤回',
          content: '确定撤回吗?',
          okText: '确认',
          cancelText: '取消',
          onOk: () => {
            return uaaRequest('/UnifiedAppFormApi/regressionProcess', {
              taskIds: [selectRows[0].taskId],
            })
              .then((res) => {
                if (res) {
                  Modal.info({
                    title: '提示',
                    content: '撤回成功， 点击详情可再次编辑并提交申请',
                  });
                  getPage();
                } else {
                  message.info('操作失败');
                  return false;
                }
              });
          },
        });
      },
    });
  }
  return reBack;
}
