import React, { useMemo, Fragment } from 'react';
import { connect } from 'dva';
import ImportUtilBatchAudit from '@/webPublic/one_stop_public/App/ImportUtilBatchAudit';
import { isJSON } from '@/webPublic/one_stop_public/2022beidianke/isJSON';

function Index(props) {
	const {
		auditPageData: { searchCondition, searchParams },
    appId,
	} = props;
  console.log("🚀 ~ file:index method:Index line:11 -----", props, "props");
	const formPropertConfig = useMemo(
		() => {
			if (searchParams && searchParams.taskDefKey) {
				const configOption = searchCondition.find((x) => x.key === 'taskDefKey').options;
				if (configOption && configOption.length > 0) {
					const formProperties = configOption.find((x) => x.key === searchParams.taskDefKey)
						.formProperties;
					if (formProperties && formProperties.length) {
						return formProperties.find((g) => g.id === 'ImportReview');
					}
				} else {
					return null;
				}
			}
			return null;
		},
		[searchParams],
	);

	const componentProps = useMemo(() => {
	  if(!formPropertConfig || !formPropertConfig.variable){
	    return null;
    }
    const disabled = !(formPropertConfig && formPropertConfig.id === 'ImportReview');
    const taskDefName = searchCondition.find((x) => x.key === 'taskDefKey').options.find((x) => x.key === searchParams.taskDefKey).name;
    const variable = formPropertConfig && isJSON(formPropertConfig.variable) ? JSON.parse(formPropertConfig.variable) : {};
	  return {
	    btn: {
        disabled,
        name: variable?.btn?.name || '导入审批',
        type: 'primary',
      },
      importConfig: formPropertConfig && isJSON(formPropertConfig.variable) ? JSON.parse(formPropertConfig.variable) : {},
      importParams: {
        ...searchParams,
        taskDefName: taskDefName,
        appId,
      },
    };
  }, [formPropertConfig, searchParams]);

  console.log({
    formPropertConfig,
    searchParams,
    searchCondition,
    componentProps,
  });

  if(!componentProps){
    return null;
  }
	return (
		<Fragment key={'ssddd'}>
			<ImportUtilBatchAudit {...componentProps}
                            callback={() => {
                              props.getPage();
                            }}
      />
		</Fragment>
	);
}
export default connect(({ auditPageData }) => {
	return {
		auditPageData: auditPageData,
	};
})(Index);
