/**
 * 禅道 30031 已处理的页面增加导出按钮
 * */
import { message } from 'antd';
import { downloadFile } from '@/webPublic/one_stop_public/Table/globalFunction';
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import { giveBase16EnCode } from '@/webPublic/one_stop_public/Base16';

export default function exportHandledInfo({
	columns = [],
	appId = '1492048888356405248',
	type = 'handled',
  searchParams = {},
}) {
	const headers = columns
		.filter((g) => {
			return g.dataIndex !== 'operationDiy';
		})
		.map((g) => {
			if (g.title === '流程审核状态') {
				return {
					key: 'formStatusName',
					title: g.title,
				};
			}
			return {
				key: g.dataIndex,
				title: g.title,
			};
		});
	const data = {
		appId,
		type,
		headers: JSON.stringify(headers),
    ...searchParams,
		token: getToken(),
	};
	if (data.searcherKeyValue === "{}") {
		delete data.searcherKeyValue;
	}
	if (appId) {
		message.info('正在导出文件,请耐心等待');
		let url = window.CONFIG.OAUTH_ACTION_PATH + '/UnifiedAppFormApi/exportData';
		giveBase16EnCode(data, url).then((newData) => {
			console.log('newData', newData);
			if (typeof newData === 'object' && newData.url && newData.datas) {
				// newData.datas.rbin = true;
				newData.datas.token = getToken();
				return downloadFile(newData.url, newData.datas);
			} else {
				return downloadFile(url, newData);
			}
			// downloadFile(url, data);
		});
	}
}
