import ButtonDiy from '@/baseComponent/ButtonDiy';
import React, { Component, Fragment } from 'react';
import ModalBatch from './ModalBatch';
import ModalForm from './ModalForm';

export default class ButtonListDom extends Component {
	render() {
		const { config, getPage, selectRows, formValues, children, search, listData, columns, searcherKeyValue = JSON.stringify({}) } = this.props;
		return (
			<div style={{ height: '50px', padding: '12px 0 12px 12px', positon: 'relative' }}>
				{config.map((item, i) => {
					switch (item.component) {
						case 'ModalForm': // 新增按钮 + 弹窗
							return (
								<ModalForm {...item} key={item.type} getPage={getPage} selectRows={selectRows} />
							);
						case 'ModalBatch': // 一般按钮 点击后弹出 填写一些类似 审核理由 意见之类的信息
							return (
								<ModalBatch
									key={item.type}
									{...item}
									handleSelectRows={this.props.handleSelectRows}
									getPage={getPage}
									selectRows={selectRows}
								/>
							);
						case 'OpenUrl': // 点击按钮 打开一个新窗口
							return window.open(item.url);
						case 'Normal':
							return (
								<ButtonDiy
									name={item.name}
									key={item.type}
                  type={item.buttonType}
									className={item.className || 'defaultBule'}
									handleClick={() => {
										item.handleClick(selectRows, formValues, getPage, search, columns, searcherKeyValue);
									}}
								/>
							);
						case 'RenderComponent':
							return item.render({
								name: item.name,
								selectRows,
								formValues,
								getPage,
								search,
								listData,
                searcherKeyValue,
							});
						default:
							break;
						//  return <ButtonDiy></ButtonDiy>;
					}
				})}
				<span style={{ display: 'inline-block' }}>{children}</span>
			</div>
		);
	}
}
