import React, { Component } from 'react';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import Shell from '@/baseComponent/Shell';
import { getToken, setToken } from '@/utils/authority';
import config from '@/config/config';
import { getOneStopConfig, isJSON } from '@/webPublic/zyd_public/utils/utils';
import router from 'umi/router';
import qs from 'qs';

const getUrlInfo = (param) => {
	let url = window.document.location.href.toString();
	let u = url.split('?');
	if (typeof u[1] == 'string') {
		u = u[1].split('&');
		let get = {};
		for (let i in u) {
			let j = u[i].split('=');
      if(j.length > 1){
        get[j[0]] = decodeURIComponent(j[1]);
      }
		}
		return get;
	} else {
		return {};
	}
};

export default class Detail extends Component {
	constructor(props) {
		super(props);
		const { state, pathname } = this.props.location;
		let id = '';
    id = getOneStopConfig(pathname);
    if (!id) {
			id = getUrlInfo()?.id || this.props.workId;
		}

    let token = getUrlInfo().token;
    if(token){
      setToken(token);
    }
    this.minHeight = document.body.clientHeight - 110;

    this.state = {
			id,
		};
	}

	componentDidMount() {
    window.addEventListener(
      'message',
      (event) => {
        if (event && event.data && event.data.indexOf) {
          if(event.data.indexOf('iframeDetailHeight') > -1){ // 高度修改事件
            let height = Number(event.data.split('-')[1]);
            // console.log(height);
            const iframe = document.getElementById('applyIframeId');
            if (iframe && height > 950) {
              iframe.height = height;
            }
          }
          if(event.data.indexOf('routerChange') > -1){ // 路由改变事件
            let jsonData = event.data.split('-')[1];
            if(isJSON(jsonData)){
              let changeData = JSON.parse(jsonData);
              router[changeData.type](changeData.arg);
              console.log(changeData);
            }
          }
        }

      },
      false,
    );
	}

  // static getDerivedStateFromProps(nextProps, prevState) {
	//   if(nextProps.workId && prevState.id && nextProps.workId !== prevState.id){
	//     return {
	//       id: nextProps.workId,
  //     };
  //   }else{
	//     return null;
  //   }
  //   // ...
  // }

  render() {
		const { id } = this.state;
		const { query } = this.props?.location;
		const queryInfo = query && typeof query === 'object' ? qs.stringify(query) : '';
		let iframeUrl = `${config.gateWayPort}/portal/#/showSmartFormOnly?id=${id}&token=${getToken()}&isShow=true`;
    // iframeUrl = `https://yx.bpi.edu.cn/portal/#/showSmartFormOnly?id=${id}&token=${getToken()}&isShow=true`;
    iframeUrl = `http://xg.qnzy.net:51352/portal/#/showSmartFormOnly?id=${id}&token=${getToken()}&isShow=true`;
		// iframeUrl = `http://localhost:8022/portal/#/showSmartFormOnly?id=${id}&token=${getToken()}&isShow=true`;
    iframeUrl = iframeUrl + '&' + queryInfo;
		return (
			<PageHeaderWrapper title="">
				<Shell styleShell={{ marginTop: '0px' }}>
					<iframe
						src={iframeUrl}
						frameBorder={0}
						id="applyIframeId"
            name="applyIframe"
						marginWidth="0"
						marginHeight="0"
						allowtransparency="yes"
						seamless
            height={this.minHeight}
						scrolling={'no'}
						style={{
							width: '100%',
              // height: '800px',
              overflowY: 'auto',
              backgroundColor: '#fff',
						}}
					/>
				</Shell>
			</PageHeaderWrapper>
		);
	}
}
