import React, { Component } from 'react';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import Shell from '@/baseComponent/Shell';
import { getToken, setToken } from '@/utils/authority';
import config from '@/config/config';
import { getOneStopConfig, isJSON } from '@/webPublic/zyd_public/utils/utils';
import router from 'umi/router';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';

export default class Detail extends Component {
	constructor(props) {
		super(props);
    let token = getUrlInfo().token;
    if(token){
      setToken(token);
    }
    this.minHeight = document.body.clientHeight - 110;
	}

	componentDidMount() {
    window.addEventListener(
      'message',
      (event) => {
        if (event && event.data && event.data.indexOf) {
          if(event.data.indexOf('iframeDetailHeight') > -1){ // 高度修改事件
            let height = Number(event.data.split('-')[1]);
            // console.log(height);
            const iframe = document.getElementById('applyIframeId');
            if (iframe && height > 950) {
              iframe.height = height;
            }
          }
          if(event.data.indexOf('routerChange') > -1){ // 路由改变事件
            let jsonData = event.data.split('-')[1];
            if(isJSON(jsonData)){
              let changeData = JSON.parse(jsonData);
              router[changeData.type](changeData.arg);
              console.log(changeData);
            }
          }
        }

      },
      false,
    );
	}

  render() {
	  const path = window.location.href.split('/').pop();
	  let prefix = window.location.origin + `/yxAdmin/#/`;
	  if(process.env.NODE_ENV === 'development'){
	    prefix = 'https://yx.bpi.edu.cn/yxAdmin/#/';
    }
		let iframeUrl = prefix + path + '?token=' + getToken();
		return (
			<PageHeaderWrapper title="">
				<Shell styleShell={{ marginTop: '0px' }}>
					<iframe
						src={iframeUrl}
						frameBorder={0}
						id="applyIframeId"
            name="applyIframe"
						marginWidth="0"
						marginHeight="0"
						allowtransparency="yes"
						seamless
            height={this.minHeight}
						scrolling={'no'}
						style={{
							width: '100%',
              // height: '800px',
              overflowY: 'auto',
              backgroundColor: '#fff',
						}}
					/>
				</Shell>
			</PageHeaderWrapper>
		);
	}
}
