import React, { Fragment, Component } from 'react';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import Shell from '@/baseComponent/Shell';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import router from 'umi/router';
import { getToken } from '@/utils/authority';
import config from '@/config/config';

export default class Detail extends Component {
	constructor(props) {
		super(props);
		const { state } = this.props.location;
		let id = '';
		if (state && state.record && state.record.id) {
			const { record } = state;
			id = record.id;
		}
		this.state = {
			id,
		};
	}

	componentDidMount() {
		window.addEventListener(
			'message',
			(event) => {
				if (event.data && event.data.indexOf && event.data.indexOf('iframeDetailHeight') > -1) {
					const height = Number(event.data.split('-')[1]);
					document.getElementById('detailIframeId').height = height;
				}
			},
			false,
		);
	}

	showAll = () => {
		this.setState({
			showAll: true,
		});
	};

	render() {
		const { id, showAll } = this.state;
		const url = config.onestopPC.split('/#/');
		const iframeUrl = `${url[0]}/#/IFrameSnapshot?token=${getToken()}`;
		// iframeUrl = `http://localhost:8000/onestop/IframeForDetail?id=${id}&token=${getToken()}`;
		return (
			<div style={{ position: 'relative' }}>
				<PageHeaderWrapper title="">
					{/* <Shell>
					<div
						style={{
							height: '54px',
							padding: '12px 0 12px 12px',
						}}>
						{showAll ? (
							<ButtonDiy
								name="返回"
								className="defaultBlue"
								handleClick={() => {
									router.goBack();
								}}
								icon="arrow-left"
							/>
						) : null}
					</div>
				</Shell> */}
					{showAll ? (
						<div
							style={{
								position: 'absolute',
								width: 335,
								height: 38,
								background: '#fff',
								top: 77,
								left: 0,
								zIndex: 10,
							}}
						/>
					) : (
						''
					)}
					<Shell>
						<iframe
							src={iframeUrl}
							frameBorder={0}
							id="detailIframeId"
							name="applyIframe"
							marginWidth="0"
							marginHeight="0"
							onLoad={this.showAll}
							allowtransparency="yes"
							seamless
							scrolling={'no'}
							style={{
								width: '100%',
								overflowY: 'hidden',
								minHeight: '800px',
							}}
						/>
					</Shell>
				</PageHeaderWrapper>
			</div>
		);
	}
}
