import { text, number, date, format, taskNode } from '../config/index';
import { isJSON } from '@/baseComponent/utils';
import { translateAddFields, getSearchCondition } from '../config/index';
import config from '@/config/config';
import { Tooltip, Modal } from 'antd';
import moment from 'moment';
import React from 'react';
import { findListTaskDefinition } from '@/webPublic/FormInsertDiy/AffairPage/publicApiService';
import QRCode from 'qrcode.react';
import styles from './styles.less';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';
import { queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';

const handleSqlModels = (sqlModels, defaultValues) => {
  if (typeof sqlModels === 'undefined' || !Array.isArray(sqlModels)) {
    return [];
  } else {
    let res = [];
    for (let x of sqlModels) {
      let key = x.key;
      if (!isJSON(x.cols)) {
        let info = x.dataObjModel.columnModels;
        for (let item in info) {
          let z = info[item];
          let oneFields = {
            key: key + '_' + z.name,
            name: z.title,
            dataType: z.type,
            required: false,
            dataId: item,
            comName: date.indexOf(z.type) > -1 ? 'DatePicker' : 'Input',
            disabled: true,
          };
          oneFields.defaultValue = defaultValues[oneFields.key] || '';
          res.push(oneFields);
        }
        continue;
      }
      let info = JSON.parse(x.cols); // name, title, type
      for (let item in info) {
        let z = info[item];
        let oneFields = {
          key: key + '_' + z.name,
          name: z.title,
          dataType: z.type,
          required: false,
          dataId: item,
          comName: date.indexOf(z.type) > -1 ? 'DatePicker' : 'Input',
          disabled: true,
        };
        oneFields.defaultValue = defaultValues[oneFields.key] || '';
        res.push(oneFields);
      }
    }
    return res;
  }
};

const funcHandleFileds = (source, obj, fieldsColumns) => {
  let fileds = [];
  for (let item of source) {
    for (let info of item) {
      let oneFiled = {};
      if (info.content) {
        let content = info.content;

        oneFiled = {
          comName: content.comName,
          name: content.label || '',
        };
        if (content.comName === 'DatePicker') {
          if (content.format) {
            oneFiled.format = content.format;
          }
        }
        if (content.comName === 'PartForm') {
          const {
            childFormKey,
            columnIds
          } = content;
          if (childFormKey) {
            let thisSource = (obj[childFormKey] && obj[childFormKey].items) || [];
            let thisFields = funcHandleFileds(thisSource, obj, fieldsColumns);
            for (let i = 0; i < thisFields.length; i++) {
              if (typeof thisFields[i].c1 !== 'undefined') {
                thisFields[i] = {
                  ...fieldsColumns[thisFields[i].c1],
                  ...thisFields[i],
                };
              }
            }
            oneFiled.componentProps = {
              columnIds,
              childFormKey,
              thisFields,
            };
          }
        }
        if (content.comName === 'RangePicker') {
          if (content.format) {
            oneFiled.format = content.format;
          }
        }
        if (content.comName === 'Description') {
          oneFiled.key = content.sqls[1];
        }
        if (['Radio', 'Select', 'Checkbox'].indexOf(content.comName) > -1) {
          // 枚举值
          if (content.optionType) {
            oneFiled.optionType = content.optionType;
            switch (oneFiled.optionType) {
              case 'enum':
                if (content.enums) {
                  let options = isJSON(content.enums) ? JSON.parse(content.enums) : [];
                  options = options.map((x) => {
                    return {
                      key: x.value,
                      name: x.label
                    };
                  });
                  oneFiled.options = options;
                }
                break;
              case 'reference':
                oneFiled.filterSql = content.filterSql;
                break;
              case 'sql':
                oneFiled.sqlKey = content.sqlKey;
                oneFiled.labelName = content.labelName;
                oneFiled.valueName = content.valueName;
                break;
              default:
                oneFiled.options = [];
                break;
            }
          }
        }
        if (content.comName === 'ChildForm') {
          const {
            childFormKey,
            columnIds
          } = content;
          let thisSource = obj[childFormKey].items;
          let thisFields = funcHandleFileds(thisSource, obj, fieldsColumns);
          for (let i = 0; i < thisFields.length; i++) {
            if (
              typeof thisFields[i].c1 !== 'undefined' &&
              typeof fieldsColumns[thisFields[i].c1] !== 'undefined'
            ) {
              thisFields[i] = {
                ...fieldsColumns[thisFields[i].c1],
                ...thisFields[i],
              };
            }
          }
          oneFiled.componentProps = {
            columnIds,
            childFormKey,
            thisFields,
          };
        }
        if (content.comName === 'TableSelect') {
          oneFiled.componentProps = {
            sqlKey: content.sqlKey,
            labelName: content.labelName,
            valueName: content.valueName,
            isMultiple: content.isMultiple,
          };
        }
        if (content.comName === 'Label') {
          // 提示信息显示
          if (info.hidden) {
            continue;
          }
          oneFiled.key = content.initialValue ? content.initialValue.slice(0, 10) : ' ';
          oneFiled.name = ' ';
          oneFiled.defaultValue = content.initialValue;
          oneFiled.dataType = 'TEXT';
        }
        for (let j in content.columnIds) {
          let oneFields = content.columnIds[j];
          oneFiled[j] = oneFields[1];
        }
        fileds.push(oneFiled);
      }
    }
  }

  return fileds;
};

export async function destructionGetDetail(response, workId) {
  /**
   * 如果数据校验不通过直接pass 返回默认值,
   * */
  if (
    typeof response.unifiedServicePatternModel === 'undefined' ||
    !isJSON(response.unifiedServicePatternModel.content) ||
    !Array.isArray(response.unifiedServicePatternModel.dataObjModels) ||
    !response.unifiedServicePatternModel.dataObjModels.length ||
    typeof response.unifiedServicePatternModel.dataObjModels[0].columnModels === 'undefined'
  ) {
    return {
      addFields: [],
      tableInfo: {},
      allConfigSetInfo: response,
      searchCondition: [],
    };
  }
  const basicPatternModel = response.unifiedServicePatternModel;

  /** 正式开始 **/

  /*** 字段name, dataType ***/
  let fieldsColumns = {};
  for (let dataObjModels of basicPatternModel.dataObjModels) {
    let columns = dataObjModels.columnModels;
    for (let item of columns) {
      fieldsColumns[item.base52] = {
        name: item.title,
        dataType: item.type,
        key: item.base52,
        dataId: item.id,
        referenceCodeName: item.referenceCodeName,
        referenceNameName: item.referenceNameName,
        required: Boolean(!item.isNull),
      };
    }
  }

  /*** 字段组件类型  ***/
  let data = JSON.parse(basicPatternModel.content);
  let key = data.init;
  let source = data.datas[key].items;
  let fileds = funcHandleFileds(source, data.datas, fieldsColumns);

  /***  字段默认值 ***/
  let sqlModeData = handleSqlModels(basicPatternModel.sqlModels, basicPatternModel.defaultValues); //Array
  let defaultBinds = data.datas[key].defaultBinds;
  let defaultKeys = {};
  if (defaultBinds) {
    for (let item in defaultBinds) {
      let one = defaultBinds[item];
      if (one && one.columnIds && one.sqls) {
        defaultKeys[one.sqls[1]] = one.columnIds[1];
      }
    }
  }
  for (let item of sqlModeData) {
    if (defaultKeys[item.key]) {
      item.defaultKey = defaultKeys[item.key];
    }
  }

  /***  流程表数据 ***/
  let tableInfo = {
    base52: basicPatternModel.dataObjModels[0].base52,
    name: basicPatternModel.dataObjModels[0].name,
    defaultValuesId: key,
  };
  for (let i = 0; i < fileds.length; i++) {
    let item = fileds[i];
    if (item.comName === 'Description') {
      if (
        item.key &&
        !item.defaultValue &&
        basicPatternModel.defaultValues &&
        basicPatternModel.defaultValues[item.key]
      ) {
        item.defaultValue = basicPatternModel.defaultValues[item.key];
      }
      for (let x of sqlModeData) {
        if (x.key === item.key) {
          item.c1 = x.defaultKey;
          fileds[i] = {
            ...item,
            ...x,
          };
        }
      }
    }
  }
  for (let i = 0; i < fileds.length; i++) {
    if (typeof fileds[i].c1 !== 'undefined') {
      if (
        fileds[i].key &&
        fieldsColumns[fileds[i].c1] &&
        fieldsColumns[fileds[i].c1].key &&
        fileds[i].key !== fieldsColumns[fileds[i].c1].key
      ) {
        fileds[i].onestopDefaultKey = fileds[i].key;
      }
      fileds[i] = {
        ...fileds[i],
        ...fieldsColumns[fileds[i].c1],
      };
    }
  }

  const searchCondition = await getSearchCondition(basicPatternModel?.dataObjModels[0]?.id, workId);  // ,response.id),

  if (response.isShowWaitTaskDef || response.isShowHandledTaskDef) {
    const optProcess = await findListTaskDefinition({
      appId: response.id,
    });
    if (optProcess) {
      searchCondition.unshift({
        key: 'taskDefKey',
        name: '流程节点',
        type: 'select',
        options: optProcess.map((g) => {
          return {
            key: g.id,
            name: g.name,
            formProperties: g.formProperties,
          };
        }),
      });
    }
  }

  return {
    addFields: [], // await translateAddFields(fileds, tableInfo),
    tableInfo,
    allConfigSetInfo: response,
    searchCondition,
    // 姚鑫国改这里
  };
}

export function getDefaultValues(addFields = [], tableInfo = {}) {
  const values = {
    defaultValues: {
      [tableInfo.defaultValuesId]: {},
    },
  };
  const defalutValues = {};
  for (let item of addFields) {
    if (typeof item.defaultValue !== 'undefined') {
      values[item.key] = item.defaultValue;
      // values[item.onestopDefaultKey] = item.defaultValue;l;l
    }
    if (typeof item.defaultKey !== 'undefined' && item.defaultKey) {
      values[item.defaultKey] = item.defaultValue; // 表单渲染需要这个值
      defalutValues[item.key] = item.defaultValue;
      defalutValues[item.onestopDefaultKey] = item.defaultValue;
    }
  }
  values.defaultValues[tableInfo.defaultValuesId] = defalutValues; //传给后台需要这个值
  return values;
}

export function handleColumns(columns) {
  const columnsLength = columns.length;
  for (let item of columns) {
    if (item.dataIndex.indexOf('process_status') > -1) {
      item.render = (val) => (val ? (val === '0' ? '审核通过' : '审核未通过') : null);
    }
    if (item.dataType) {
      if (text.indexOf(item.dataType) > -1) {
        // 文本类型字段
        item.render = (text) => {
          if (isJSON(text)) {
            text = JSON.parse(text);
          }
          if (item.extendType === 'qrCode') {
            if (text && typeof text === 'string' && text) {
              let url = text.replace('{window.location.origin}', config.gateWayPort);
              const clickUrl = () => {
                Modal.info({
                  title: item.title,
                  content: <div className={styles.erweimaModal}>
                    <QRCode
                      bgColor="#FFFFFF"
                      fgColor="#000000"
                      level="Q"
                      size={200}
                      style={{
                        display: 'block',
                        margin: 'auto',
                      }}
                      value={url}
                    /></div>,
                });
              };
              return (<a onClick={clickUrl}>查看</a>);
            } else {
              return <span>暂无</span>;
            }

          }
          if (item.extendType === 'file' && typeof text === 'string') {
            let url = queryFileUrl(text);
            return (
              <a href={url} target={'_blank'}>
                点击查看
              </a>
            );
          } else if (typeof text === 'string' && text.length > 25) {
            // 25621 双选会--单位申请审核，，加一个申请展位字段
            // 把20 变成了 25 如果不好解决 就通过width做判断依据
            const oldTitle = text;
            const newTitle = text.slice(0, 25) + '...';
            return (
              <Tooltip title={oldTitle} key={oldTitle} style={{ width: 260 }}>
                <span key={text}>{newTitle}</span>
              </Tooltip>
            );
          } else if (
            item.extendType === 'file' &&
            text &&
            typeof text === 'object' &&
            Array.isArray(text.files) &&
            text.files.length
          ) {
            return text.files.map((file, index) => {
              if(typeof file.path !== 'string' ){
                return null;
              }
              let url = queryFileUrl(file.path);
              return (
                <a href={url} target={'_blank'} key={file.name} style={{ marginRight: '10px' }}>
                  {file.name}
                </a>
              );
            });
          } else {
            return text;
          }
        };
      } else if (date.indexOf(item.dataType) > -1) {
        // 日期类型字段
        item.render = (text, record) => {


          if (!isNaN(Number(text)) && Number(text) > 10000000) {
            text = Number(text);
            if (item.dataFormatStrWeb) {
              return moment(text)
                .format(item.dataFormatStrWeb);
            }
            return moment(text)
              .format(format[item.dataType]);
          } else if (typeof text === 'string' && text.length > 5) {
            return moment(text)
              .format(item.dataFormatStrWeb || 'YYYY-MM-DD');
          } else {
            return '';
          }
        };
      } else if (taskNode.indexOf(item.dataType) > -1) {
        // 流程节点类型
        item.render = (text, record) => {
          if (record.isEnd) {
            return '已完成';
          } else {
            return text || record.taskName;
          }
        };
      }
    }

    if (item.dataIndex === 'rate') {
      item.render = (text, record) => {
        if (text || text == 0) {
          return Number(text) + '%';
        } else {
          return '';
        }
      };
    }

  }
  return columns;
}
