/**
 * 事务页面。 根据事务接口。达到增删发起事务流程
 * 2019年10月23日 09:48:13
 * 钟是志
 *
 * */

import { apiRequest } from '../request';
import { getHistoryFormDetail } from '@/webPublic/Services';
import { getOneStopConfig } from '@/webPublic/zyd_public/utils/utils';

const giveValue = (x) => {
	if (x && x.rows) {
		let res = [];
		for (let item of x.rows) {
			res.push({
				...item.hisTaskListData,
				...item,
			});
		}
		x.rows = res;
		return x;
	} else {
		return {
			rows: [],
			total: 1,
		};
	}
};

const getId = async (pathname) => {
	// 获取流程引擎 事务workId 和表dataBaseId
	let idObj = await getOneStopConfig(pathname);
	if (typeof idObj === 'undefined' || !idObj) {
		console.error('没有找到对应的流程引擎id');
		return false;
	} else {
		return {
			dataBaseId: idObj,
			workId: idObj,
		};
	}
};

const getPages = (info) => {
	// 获取代办事项 分页数据 workId
	// workId, pageSize, pageNo,
	if (typeof info.pageNo === 'undefined') {
		info.pageNo = 1;
		info.pageSize = 10;
	}
	return apiRequest('/UnifiedAppFormApi/getWaitPage', info);
};

const filterHeaderColumns = (res, workId) => {
  // 27355 门户---单位个人中心，，双选会申请，，不要营业执照字段
  if(workId === '1366228504210833408' &&
    window.location.href.indexOf('/CompanyCenter') > -1 && Array.isArray(res)
  ){
    res = res.filter((g) => {
      return g.dataIndex !== 'LfKUHjglHFM';
    })
  }

  return res;
}


const getColumns = (workId) => {
	//
	return apiRequest('/UnifiedAppFormApi/getFormTitle', { id: workId }).then((res) => {
    return filterHeaderColumns(res, workId);
  });
};

const findListTaskDefinition = (params) => {
  // 获取流程审核节点
  return apiRequest('/UnifiedAppFormApi/findListTaskDefinition', params);
};

const getHead = (dataObjId) => {
	return apiRequest('/DataColumnApi/getHeaderList', { dataObjId });
};

const getGroupList = ({columnId, appId = undefined}) => {
	return apiRequest('/DataColumnApi/getGroupList', { columnId, appId });
};

/**
 * 获取下拉枚举值
 * */
const getOptions = async (id, filterSql = undefined, key, name) => {
	return await apiRequest('/DataColumnApi/getOptions', { id, filterSql }).then((x) => {
		if (x) {
			return x.map((y) => {
				return {
					key: y[key],
					name: y[name],
				};
			});
		} else {
			return [];
		}
	});
};

/**
 * 批量获取下拉枚举值
 * */
const getBatchOptions = async (ids) => {
	return await apiRequest('/DataColumnApi/getBatchOptions', { ids });
};

/**
 * 获取下拉枚举值 通过sql语句
 * */
const getSqlOptions = async (id, sqlKey = undefined, key, name) => {
	return await apiRequest('/DataColumnApi/getSqlOptions', { id, sqlKey }).then((x) => {
		if (x) {
			return x.map((y) => {
				return {
					key: y[key],
					name: y[name],
				};
			});
		} else {
			return [];
		}
	});
};

/**
 * 获取发起流程填写的字段表单详情
 * */
const getFormDetail = (id) => {
	return apiRequest('/UnifiedAppApi/getDetail', { id }).then((x) => {
		if (x) {
			return x;
		} else {
			return {};
		}
	});
	/**
   * 这里不能调prepareShow. 因为模板还没挂载
   * */
  //   .then((res) => {
  //   return prepareShow(res).then((x) => {
  //     return res;
  //   });
  // });
};

/**
 *
 * */
const getServiceDetail = (id) => {
  return apiRequest('/UnifiedServiceApi/getDetail', { id }).then((x) => {
    if (x) {
      return x;
    } else {
      return {};
    }
  });
};

/**
 *  发起流程
 * */
const startProcess = (info) => {
	return apiRequest('/UnifiedAppFormApi/startProcess', info).then((x) => {
		if (x) {
			return x;
		} else {
			return null;
		}
	});
};

/**
 *  查询已发起的流程的分页接口
 *
 * */

const getApplyPage = (info) => {
	return apiRequest('/UnifiedAppFormApi/getApplyPage', info).then((x) => {
		return giveValue(x);
	});
};
/**
 *  查询一个流程的详情数据
 *
 * */

const getDetailInfo = (id) => {
  return getHistoryFormDetail({id}).then((x) => {
		if (x) {
			return x;
		} else {
			return null;
		}
	});
};
/**
 * 待办业务
 * pageSize: 10
 * appId: 1185524814832467968
 * pageNo: 1
 * */
const getWaitPage = (info) => {
	return apiRequest('/UnifiedAppFormApi/getWaitPage', info).then((x) => {
	  if(x && x.rows){
	    for(let item of x.rows){
	      item.operationDiy = '审核';
      }
    }
		return giveValue(x);
	});
};
/**
 * 已办业务
 * pageSize: 10
 * appId: 1185524814832467968
 * pageNo: 1
 * */
const getHandledPage = (info) => {
	return apiRequest('/UnifiedAppFormApi/getHandledPage', info).then((x) => {
		return giveValue(x);
	});
};

/**
 * 审核接口,支持批量
 *  taskIds: 08d8d359-f7a6-11e9-9a27-0242b1fd760b
 *  examineMap: {"examine":"0","reason":"通过"}
 *  taskForm: {}
 * */
const handleAudit = (info) => {
	return apiRequest('/UnifiedAppFormApi/examineProcess', info).then((x) => {
		if (x) {
			return x;
		}
	});
};

const handleSqlData = (info) => {
	return apiRequest('/DataColumnApi/getSqlData', info).then((x) => {
		if (x) {
			return x;
		} else {
			return [];
		}
	});
};

const handleSqlfind = async (sqlKey = '') => {
	return await apiRequest('/SqlManageEntityApi/find', { sqlKey }).then((x) => {
		if (x) {
			return x;
		} else {
			return null;
		}
	});
};

export {
	getId,
	getColumns,
	getPages,
	getFormDetail,
  getServiceDetail,
	getOptions,
	getBatchOptions,
	startProcess,
	getApplyPage,
	getDetailInfo,
	getWaitPage,
	getHandledPage,
	handleAudit,
	handleSqlData,
	handleSqlfind,
	getSqlOptions,
	getHead,
	getGroupList,
  findListTaskDefinition,
};
