import React from 'react';
import { Form } from 'antd';
import router from 'umi/router';
import Entrance from '../Entrance';
import Shell from '@/baseComponent/Shell';
import SubmitButton from '@/webPublic/one_stop_public/AffairButton/SumbitButton';
import { ModalInfo } from '@/baseComponent/Modal';
import withGoBack from '@/highOrderComponent/withGoBack';

let ApplyPage = ({ id, form }) => {
	function submitCb(res) {
		ModalInfo(`提交${res ? '成功' : '失败'}！`, { onOk: () => router.goBack() });
	}
	function saveDraftCb(res) {
		ModalInfo(`提交${res ? '成功' : '失败'}！`, { onOk: () => router.goBack() });
	}

	return (
		<Shell styleShell={{ marginTop: 0 }}>
			<Entrance id={id} isCg="false" get="web" form={form} />
			<div style={{ padding: 16, textAlign: 'center' }}>
				<SubmitButton
					form={form}
					appId={id}
					text="提交"
					openDraftButton
					DraftButtonText="暂存"
					callback={submitCb}
					draftCallback={saveDraftCb}
				/>
			</div>
		</Shell>
	);
};

ApplyPage = Form.create()(ApplyPage);

export default ({ hasGoBack = true, ...rest }) => {
	const WithGoBack = withGoBack(ApplyPage);
	return hasGoBack ? <WithGoBack {...rest} /> : <ApplyPage {...rest} />;
};
