/**
 * 批量审核一个一个的调接口 解决性能问题
 * */
import React, { useState, useEffect, useRef } from 'react';
import { Modal, Progress,message } from 'antd';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';
import styles from './styles.less';

export default function AuditProcessOneByOne({
                                             payloadData = {},
                                             callBack = () => {
                                             },
                                             setShowProcessModal,
                                           }) {
  if (!Array.isArray(payloadData?.taskIds) || !payloadData.taskIds.length) {
    return null;
  }
  const [success, setS] = useState(0);
  const [error, setE] = useState(0);
  const resInfo = useRef();
  const taskIds = payloadData.taskIds;
  const total = taskIds.length;

  async function getData(){
    for (let g = 0; g < taskIds.length; g++) {
      const res = await returnPromise({
        ...payloadData,
        taskIds: [taskIds[g]],
      });
      if (res) {
        setS((v) => v + 1);
      } else {
        setE((v) => v + 1);
      }
      resInfo.current = res;
    }
  }

  useEffect(() => {
    getData();
  }, []);

  useEffect(() => {
    if (success + error === total) {
      callBack(resInfo.current);
    }
  }, [success, error]);


  const percent = Math.floor(((success + error) / total) * 100);
  return (
    <Modal title={'批量审核'}
           visible={true}
           width={1200}
           footer={null}
           onCancel={() => {
             if(success + error !== total){
               message.warning('审核正在进行中,请勿关闭');
             }else{
               setShowProcessModal(false);
             }
           }}
    >
      <div className={styles.juzhong}>
        <Progress percent={percent}
                  type='circle'
                  status={error === total ? 'exception' : success + error === total ? 'success ' : ''}
                  strokeColor={{
                    '0%': '#108ee9',
                    '100%': '#87d068',
                  }}
        />

        <div >
          {
            success + error === total ? `审核完成, 成功${success}条, 失败${error}条` : `正在进行审核 共${total}条数据, 成功${success}条, 失败${error}条`
          }
        </div>
      </div>


    </Modal>
  );
}

let i = 0;

function returnPromise(data) {
  // return new Promise((resolve, reject) => {
  //   i++;
  //   if (i % 2 > 0) {
  //     resolve(true);
  //   } else {
  //     resolve(false);
  //   }
  // });
  return uaaRequest('/UnifiedAppFormApi/examineProcess', data);
}
