import router from 'umi/router';
import { Form, Spin } from 'antd';
import Shell from '@/baseComponent/Shell';
import { ModalInfo } from '@/baseComponent/Modal';
import React, { useState, useEffect } from 'react';
import { getHistoryFormDetail } from '../../Services';
import withGoBack from '@/highOrderComponent/withGoBack';
import HistoryForm from '@/webPublic/FormInsertDiy/HistoryForm';
import AuditButton from '../AuditButton';
import styles from '../RenderForm/index.less';

let AuditForm = ({ code, isNewForm, form }) => {
	function submitCb(res) {
		ModalInfo(`提交${res ? '成功' : '失败'}！`, { onOk: () => router.goBack() });
	}
	const [data, setData] = useState(null);
	const [loading, setLoading] = useState(false);

	useEffect(() => {
		if (typeof code === 'undefined') return;
		setLoading(true);
		getHistoryFormDetail({ code }).then((res) => {
			setLoading(false);
			if (res && !res.errMsg) {
				setData(res);
			}
		});
	}, []);

	return (
		<Shell styleShell={{ marginTop: 0 }}>
			<Spin spinning={loading}>
				{data && (
					<>
						<div className={styles.zyd_onestop_style_class}>
							<HistoryForm
								data={data} // 'affair/getIdFormDetail' 接口返回数据
								form={form} // form控件
								isNewForm={!!isNewForm} // 是否渲染需要当前用户填写的审核表单 为false只会渲染历史回显表单
							/>
						</div>

						{isNewForm && (
							<div style={{ padding: 16, textAlign: 'center' }}>
								<AuditButton
									data={data} // 为 'affair/getIdFormDetail' 接口请求到的数据
									callback={submitCb} // 提交完成后回调函数
									form={form} // form表单控件
								/>
							</div>
						)}
					</>
				)}
			</Spin>
		</Shell>
	);
};

AuditForm = Form.create()(AuditForm);

export default ({ hasGoBack = true, ...rest }) => {
	const WithGoBack = withGoBack(AuditForm);
	return hasGoBack ? <WithGoBack {...rest} /> : <AuditForm {...rest} />;
};
