import React, { useState } from 'react';
import PageTypeMatching from '@/highOrderComponent/PageTypeMatching';
import getInfoGenerator from '@/webPublic/FormInsertDiy/getInfoGenerator';
import AuditModal from './AuditModal';
import { findValueByKey } from '../../../../pages/zydtw/Cxcy/utils';
import withGoBack from '@/highOrderComponent/withGoBack';
import ButtonDiy from '@/baseComponent/ButtonDiy';

const defaultNameSpan = { big: 9, small: 9 };
const defaultFieldSpan = { big: 4, small: 4 };

const defaultPageSetting = {
	selectRows: true,
	paging: true,
	searchArea: true,
	buttonArea: true,
};

export default withGoBack(function BatchAudit({
	appId,
	flowNode,
	getInfo,
	condition,
	nameSpan,
	fieldSpan,
	tableRowKey,
	columns,
	pageButton,
	pageSetting,
}) {
	const pageSearch = {
		search: {
			searchType: 'cascadeSearchNew',
			getInfo: getInfo || getInfoGenerator(condition),
			url: '/common/assigneeTasks',
			field: {
				appId: {
					required: true,
					defaultValue: appId,
				},
				flowNode: {
					required: true,
					defaultValue: flowNode,
				},
			},
			condition: condition || [],
			nameSpan: nameSpan || defaultNameSpan,
			fileSpan: fieldSpan || defaultFieldSpan,
		},
		tableRowKey: tableRowKey || 'buzinessId',
		columns: columns || [],
	};

	const defaultPageButton = [
		{
			type: 'create',
			name: '批量审核',
			component: 'RenderComponent',
			render: ({ selectRows, getPage }) => {
				const disabled = !selectRows || !Array.isArray(selectRows) || !selectRows.length;
				return (
					<AuditModal
						selectRows={selectRows.map((i) => ({ ...i, code: findValueByKey(i, 'code') }))}
						getPage={getPage}>
						{({ onShow }) => <ButtonDiy name="批量审核" handleClick={onShow} disabled={disabled} />}
					</AuditModal>
				);
			},
		},
	];

	return (
		<PageTypeMatching
			tabsShellStyle={{ marginTop: 0 }}
			pageSetting={{ type: 'list', listConfig: { ...defaultPageSetting, ...pageSetting } }}
			pageButton={pageButton || defaultPageButton}
			pageSearch={pageSearch}
		/>
	);
});
