import moment from 'moment';
import React from 'react';
import { Icon } from 'antd';
import { deepCopy, isJSON } from '@/baseComponent/utils';
import { Link, hashHistory } from 'dva/router';
import { truncate } from 'lodash';
import Detail from './Detail';

const giveProps = ({ auditStatus, unitId, options }) => {
	const tab1 = {
		search: {
			url: '/InstructorDepartApi/getInstitutionPage',
			field: {
				auditStatus: {
					required: true,
					defaultValue: auditStatus,
				},
				flowNode: {
					required: true,
					defaultValue: 'depart_audit', // 学院分管领导
				},
			},
			beforeGetPage: (data) => {
				if (data.institutionId) {
					data.unitId = data.institutionId;
				}
				return data;
			},
			responseCallBack: ({ rows, ...rest }) => {
				return {
					rows: rows.map((record) => {
						let { reason } = record;
						if (reason && isJSON(reason)) {
							const parsed = JSON.parse(reason);
							reason = parsed.reason;
							const { attachment, remark, isPublish } = parsed;
							return {
								...record,
								reason,
								attachment: attachment || [],
								remark,
								isPublish: !!isPublish,
							};
						}
						return { ...record, reason };
					}),
					...rest,
				};
			},
			condition: [
				{
					key: 'startTime',
					endKey: 'endTime',
					name: '创建时间',
					type: 'rangePicker',
					format: 'YYYY-MM-DD',
				},
				{
					key: 'department',
					name: '扣分部门',
					type: 'select',
					options,
				},
			],
			nameSpan: { big: 8, small: 9 },
			fileSpan: { big: 4, small: 3 },
		},
		tableRowKey: 'id',
		columns: [
			{
				dataIndex: 'insYear',
				title: '年度',
			},
			{
				dataIndex: 'totalScore',
				title: '扣分分值',
			},
			{
				dataIndex: 'departName',
				title: '扣分部门',
			},
			{
				dataIndex: 'reason',
				title: '扣分原因',
				render: (text) => {
					return truncate(text, {
						length: 30,
						omission: '...',
					});
				},
			},
			{
				dataIndex: 'recorderDate',
				title: '时间',
				render: (text) => {
					return text ? moment(text).format('YYYY-MM-DD HH:mm') : '';
				},
			},
			{
				dataIndex: 'auditStatus',
				title: '状态',
				render: (text) => {
					switch (text) {
						case 4:
							return '进行中';
						case 5:
							return '完成扣分';
						case 1:
							return '已完成';
						case 2:
							return <span style={{ color: 'red' }}>进行中</span>;
						case 0:
							return <span style={{ color: '#1998f0' }}>进行中</span>;
						default:
							return '';
					}
				},
			},
			{
				dataIndex: 'operation',
				title: '操作',
				renderConfig: {
					type: 'component',
					render: (args) => {
						return <Detail {...args} unitId={unitId} />;
					},
				},
			},
		],
	};
	const tab2 = deepCopy(tab1);
	//const tab3 = deepCopy(tab1);
	const pageSearch = {
		tab1,
		tab2,
		//tab3,
	};
	return pageSearch;
};

export default giveProps;
