import React from 'react';
import RenderForm from '@/webPublic/FormInsertDiy/RenderForm';
import { fetchTemplateById } from '@/webPublic/Services';
import { useState, useEffect } from 'react';
import { Form, Modal } from 'antd';
import { getOneStopConfig } from '@/webPublic/zyd_public/utils/utils';

// const id = '1234718972352397312';

// 考核汇总页面
function OtherCheckRecord({ workId, ...otherProps }) {
  const pathname = otherProps?.location?.pathname;
  const [data, setData] = useState();
  const id = workId || getOneStopConfig(pathname);
  useEffect(() => {
    setData(undefined);
    fetchTemplateById(id).then(res => {
      if (res) setData({ ...res, content: '{}' });
    });
  }, [id]);

  if (!data) {
    return null;

  }
  if (window.zdyTableTemplateWillMountProps?.showComponentType === 'ModalAndSmartForm') {
    // 25841 学生资助管理/勤工助学-用工部门/学生申请岗位审核,2020010375 发送面试邀请后 学生没有收到 邀请信息
    // 通过增加配置项 达到 弹窗中嵌入表单的效果.
    const { ModalAndSmartForm_ModalProps } = window.zdyTableTemplateWillMountProps;
    const FormNew = Form.create(window.zdyTableTemplateWillMountProps?.formCreateOptions || undefined)(RenderForm);
    const { ModalAndSmartFormProps } = otherProps;
    window.ModalAndSmartFormProps = ModalAndSmartFormProps;
    return <Modal {...ModalAndSmartForm_ModalProps}>
      <FormNew postData={data} style={{ padding: 0 }} />
    </Modal>;
  } else {
    const FormNew = Form.create(window.zdyTableTemplateWillMountProps?.formCreateOptions || undefined)(RenderForm);
    return <FormNew postData={data} style={{ padding: 0 }} />;
  }

}

export default OtherCheckRecord;
