import React, { useState, useEffect } from 'react';
import { Tabs } from 'antd';
import { isJSON } from '@/webPublic/one_stop_public/copy'; // 申请
import CheckRecord from '@/webPublic/FormInsertDiy/ExportComponent/CheckRecord';

const TabPane = Tabs.TabPane;

export default function CheckRecordMerge(props) {
  let settingJson = isJSON(props.routerConfig?.settingJson) ? JSON.parse(props.routerConfig?.settingJson) : [];
  if(!Array.isArray(settingJson) || !settingJson.length){
    console.log('settingJson 不是一个数组 无法渲染!');
    return null;
  }
  const [activeKey, setActiveKey] = useState(settingJson[0].appId);
  const changeActiveKey = (a) => {
    setActiveKey(a);
  };
  useEffect(() => {
  }, []);

  if (!activeKey) {
    return null;
  }
  return (
    <Tabs activeKey={activeKey}
          hideAdd={true}
          style={{backgroundColor:'#fff'}}
          onChange={changeActiveKey}
    >
      {
        settingJson.map((g) => {
          const Component = CheckRecord;
          return (<TabPane tab={g.name} key={g.appId}>
            {
              activeKey === g.appId ?
                <Component workId={g.appId}
                           {...props}
                /> : null
            }
          </TabPane>);
        })
      }
    </Tabs>
  );
}
