/* eslint-disable no-nested-ternary */
/**
 * 历史表单+最新表单生成
 * data 'affair/getIdFormDetail' 接口返回的详细参数
 * form 表单控件
 * isNewForm 是否展示最新表单
 */
import React from 'react';
import { Spin, Card } from 'antd';
import { isEmpty } from '@/webPublic/one_stop_public/copy';
import RenderForm from '../RenderForm';
import styles from './index.less';

export default function HistoryForm(props) {
	const { data, isNewForm } = props;
	console.log(data, isNewForm);
	return (
		<div>
			{data.hisTaskForm.formKeys && data.hisTaskForm.formKeys.length > 0
				? data.hisTaskForm.formKeys.map((item, index) => {
						return (
							<Card
								key={item.formKey}
								title={item.taskName}
								bordered={false}
								style={{ width: 800, margin: 'auto' }}>
								{!data ? (
									<div
										style={{
											width: '100%',
											height: 200,
											display: 'flex',
											justifyContent: 'center',
											alignItems: 'center',
										}}>
										<Spin size="large" />
									</div>
								) : (
									<RenderForm
										get="web"
										isCg="no"
										postData={data}
										obj={data.hisTaskForm.formData}
										form={props.form}
										formKey={item.formKey}
									/>
								)}
							</Card>
						);
				  })
				: ''}
			{isNewForm ? ( // 展示最新表单
				data.isHandle && !!data.taskFormKey ? (
					<Card title="当前流程" bordered={false} style={{ width: 800, margin: 'auto' }}>
						{!isEmpty(data) && (
							<RenderForm
								postData={data}
								get="web"
								isCg="no"
								obj={data.hisTaskForm.formData}
								table="new"
								form={props.form}
							/>
						)}
					</Card>
				) : null
			) : null}
		</div>
	);
}
