import React from 'react';
import { Modal } from 'antd';
import { RenderFormByContent } from '../RenderForm';

const CreateForm = (props) => {
	const {
		modalVisible,
		handleAdd,
		isAdd,
		handleModalVisible,
		content,
		form,
		templateCode,
		confirmLoading,
	} = props;

	return (
		<Modal
			width="1000px"
			maskClosable={false}
			destroyOnClose
			title={isAdd ? '新增' : '编辑'}
			visible={modalVisible}
			onOk={handleAdd}
			onCancel={handleModalVisible}
			confirmLoading={confirmLoading}>
			<RenderFormByContent form={form} content={content} templateCode={templateCode} />
		</Modal>
	);
};

export default CreateForm;
