import React, { useState, useEffect } from 'react';
import { Form, Spin } from 'antd';
import { router } from 'umi';
import Shell from '@/baseComponent/Shell';
import HistoryForm from '@/webPublic/FormInsertDiy/HistoryForm';
import { getHistoryFormDetail } from '../../Services';
import withGoBack from '@/highOrderComponent/withGoBack';
import { ModalInfo } from '@/baseComponent/Modal';
import AuditButton from '../AuditButton';

// 查看详情， 传申报数据的code
let DetailPage = ({ form, code }) => {
	const [data, setData] = useState(null);
	const [loading, setLoading] = useState(false);

	useEffect(() => {
		if (typeof code === 'undefined') return;
		setLoading(true);
		getHistoryFormDetail({ code }).then((res) => {
			setLoading(false);
			if (res && !res.errMsg) {
				setData(res);
			}
		});
	}, []);

	function submitCb(res) {
		ModalInfo(`提交${res ? '成功' : '失败'}！`, { onOk: () => router.goBack() });
	}

	return (
		<Shell styleShell={{ marginTop: 0 }}>
			<Spin spinning={loading}>
				{data && (
					<>
						<HistoryForm
							data={data} // 'affair/getIdFormDetail' 接口返回数据
							form={form} // form控件
							isNewForm={data.isSecond ?? false} // 是否渲染需要当前用户填写的审核表单 为false只会渲染历史回显表单
						/>
						{data.isSecond && (
							<AuditButton
								data={data} // 为 'affair/getIdFormDetail' 接口请求到的数据
								callback={submitCb} // 提交完成后回调函数
								form={form} // form表单控件
							/>
						)}
					</>
				)}
			</Spin>
		</Shell>
	);
};

DetailPage = Form.create()(DetailPage);

export default ({ hasGoBack = true, ...rest }) => {
	const WithGoBack = withGoBack(DetailPage);
	return hasGoBack ? <WithGoBack {...rest} /> : <DetailPage {...rest} />;
};
