import React from 'react';
import PageTypeMatching from '@/highOrderComponent/PageTypeMatching';
import getInfoGenerator from '../getInfoGenerator';

export { DataType } from '../getInfoGenerator';

const defaultNameSpan = { big: 9, small: 9 };
const defaultFieldSpan = { big: 4, small: 4 };

const defaultPageSetting = {
	selectRows: true, // 是否可以行选择,
	paging: true, // 是否可以分页,
	searchArea: true, // 是否拥有 搜索区dom,
	buttonArea: true, // 是否拥有 按钮区,
};

export default function MyApplyList({
	appId,
	pageSetting = {},
	pageButton = [],
	condition = [],
	nameSpan = defaultNameSpan,
	fileSpan = defaultFieldSpan,
	tableRowKey = 'buzinessId',
	columns = [],
	scroll,
}) {
	const pageSearch = {
		search: {
			fromTab: true,
			getInfo: getInfoGenerator(condition),
			url: '/common/myApplyMap',
			field: {
				appId: {
					required: true,
					defaultValue: appId,
				},
			},
			condition,
			nameSpan,
			fileSpan,
		},
		scroll,
		tableRowKey,
		columns,
	};

	return (
		<PageTypeMatching
			pageSetting={{
				type: 'list',
				listConfig: { ...defaultPageSetting, ...pageSetting },
			}}
			bodyShellStyle={{ marginTop: condition && condition.length ? 16 : 0 }}
			pageButton={pageButton}
			pageSearch={pageSearch}
		/>
	);
}
