import React, { useEffect, useRef, useState } from 'react';
import ReactToPrint from 'react-to-print';
import styles from './index.less';
import { Button } from 'antd';
import IframeForRenderForm from './IframeForRenderForm';
import { setToken } from '@/utils/authority';
import { getIsNengYuan } from "@/webPublic/zyd_public/utils/getSchoolType";

const idsConfig = getIsNengYuan() ? [

  {
    id: '1427570690688548864',
    name: '新生入学报到单',
    key: 'xsrxbdd',
  },
] : [
   {
    id: '1427569429700411392',
    name: '新生入学登记表',
    key: 'xsrxdjb',
  },
  {
    id: '1427570690688548864',
    name: '新生入学报到单',
    key: 'xsrxbdd',
  },
];

export default function PrintQnmz(props) {
  const componentRef = useRef();
  const [showPrint, setShowPrint] = useState(false);
  useEffect(() => {
    document.title = '新生报到单打印';
    setTimeout(() => {
      setShowPrint(true);
    }, 2000);
  }, []);

  // function printDom() {
  //   document.getElementById('showButtonDiv').style.display = 'none';
  //   window.print();
  //   setTimeout(() => {
  //     document.getElementById('showButtonDiv').style.display = 'grid';
  //   }, 1000);
  // }

  return (<div>
    <div className={styles.buttonDiv} id={'showButtonDiv'}>
      {/* {
        showPrint ? <Button type={"primary"} onClick={printDom}>打印</Button> : <div>正在加载打印信息, 请稍等</div>
      }
      */}
      {
        showPrint ? <ReactToPrint
          trigger={() => <Button type={'primary'}>打印</Button>}
          content={() => componentRef.current}
          onBeforePrint={() => {
            return new Promise((resolve, reject) => {
              setTimeout(() => {
                resolve(true);
              }, 2000);
            });
          }}
        /> : <div>正在加载打印信息, 请稍等</div>
      }

      {
        showPrint && window.history.length > 1 &&
        <Button type={'danger'} onClick={() => {
          window.history.go(-1);
        }}>返回</Button>
      }

      {
        showPrint && window.history.length > 1 &&
        <Button type={'danger'} onClick={() => {
          setToken('');
          window.location.reload();
        }}>清空缓存</Button>
      }


    </div>
    <div ref={componentRef}>
      {
        idsConfig.map((x) => {
          return (
            <div style={{
              minHeight: '29cm',
              minWidth: '21cm',
              pageBreakAfter: 'always',
              display: 'flex',
              justifyContent: 'center',
              alignItems: 'center',
            }}>
              <IframeForRenderForm id={x.id} {...props} />
            </div>
          );
        })
      }
    </div>
  </div>);
}
