import { getInfo } from '@/highOrderComponent/Service';

export const DataType = {
	string: 'string',
	int: 'int',
	long: 'long',
	text: 'text',
	date: 'date',
};

export function parseParams(condition, params) {
	// 有dataType的查询条件封装到queryInfo里，其他的直接按参数查询
	// queryInfo是{key, value, dataType}对象组成的数组

	const newParams = Object.keys(params).reduce((acc, key) => {
		const value = params[key];
		const conditionItemHasDataType = condition.find(
			(item) => item.key === key && typeof item.dataType !== 'undefined',
		);

		if (conditionItemHasDataType && typeof value !== 'undefined') {
			const oldQueryInfo = acc.queryInfo || [];
			return {
				...acc,
				queryInfo: oldQueryInfo.concat({
					key,
					value,
					dataType: conditionItemHasDataType.dataType,
					op: conditionItemHasDataType.op || 'eq',
				}),
			};
		}
		return { ...acc, [key]: value };
	}, {});

	newParams.queryInfo = JSON.stringify(newParams.queryInfo || []);
	return newParams;
}

export default function getInfoGenerator(condition) {
	return (params, url) => {
		const newParams = parseParams(condition, params);
		return getInfo(newParams, url, { method: 'GET' });
	};
}
