/**
 * request 网络请求工具
 * 更详细的 api 文档: https://github.com/umijs/umi-request
 */
import { extend } from 'umi-request';
import { notification } from 'antd';
import FormdataWrapper from '@/utils/object-to-formdata-custom';
import { getToken } from '@/utils/authority';
import { offline } from './Toast';
import systemConfig from '@/config/config';
import { uaaRequest } from "@/webPublic/one_stop_public/utils/request";

const codeMessage = {
	200: '服务器成功返回请求的数据。',
	201: '新建或修改数据成功。',
	202: '一个请求已经进入后台排队（异步任务）。',
	204: '删除数据成功。',
	400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
	401: '用户没有权限（令牌、用户名、密码错误）。',
	403: '用户得到授权，但是访问是被禁止的。',
	404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
	406: '请求的格式不可得。',
	410: '请求的资源被永久删除，且不会再得到的。',
	422: '当创建一个对象时，发生一个验证错误。',
	500: '服务器发生错误，请检查服务器。',
	502: '网关错误。',
	503: '服务不可用，服务器暂时过载或维护。',
	504: '网关超时。',
};
/**
 * 异常处理程序
 */
var canReportError = true;
const errorHandler = (error) => {
	const { response } = error;

	if (response && response.status) {
		const errorText = codeMessage[response.status] || response.statusText;
		notification.error({
			message: `请求错误`,
			description: errorText,
		});

		if (response.status === 401) {
			// @HACK
			/* eslint-disable no-underscore-dangle */
			return window.g_app._store.dispatch({
				type: 'login/loginout',
			});
		}
	} else {
		if (canReportError) {
			notification.error({
				message: `网络故障`,
				description: '请检查网络链接或联系管理员',
			});
			canReportError = false;
		}
	}
};

/**
 * 配置request请求时的默认参数
 */
const umiRequest = extend({
	errorHandler, // 默认错误处理
	credentials: 'include', // 默认请求是否带上cookie
	mode: 'cors',
});

export const request = (url, data, options = {}) => {
	const pp = { ...data, token: getToken() };
	const requestParams = FormdataWrapper(pp);

	// 由于自动添加前缀 这里暂时修改getUrl(url)
	return umiRequest(url, {
		data: requestParams,
		method: 'POST',
		requestType: 'form',
		...options,
	}).then((response) => {
		if (window.location.pathname.slice(0, 15) === '/onestop/mobile') {
			if (response.errCode || response.errMsg) {
				offline(response.errMsg, 2);
				if (data.callback) data.callback(response);
				return;
			}
		}
		if (!response) return;
		if (url.indexOf('UserApi/loginByCount') > -1) {
			if (response.errMsg === '用户不存在') {
				console.error('在系统中无该用户');
				return { token: '' };
			}
		}
		if (response.errCode || response.errMsg) {
			notification.error({
				message: `请求错误`,
				description: response.errMsg,
			});
			return;
		}
		if (response.errcode) {
			notification.error({
				message: `请求错误`,
				description: response.errmsg,
			});
			return;
		}
		canReportError = true;
		return response;
	});
};

export const apiRequest = uaaRequest;

export default request;
