/****
 * 一站式请勿使用此文件
 * 存在问题
 * 钟是志
 * 2020年5月9日 19:37:52
 * */

import { uaaRequest } from './one_stop_public/utils/request';
import config from '@/config/config';
import {
	getOneStopConfig,
	setOneStopActiveMenusConfig,
	setOneStopConfig,
} from '@/webPublic/zyd_public/utils/utils';
import { getOneStopConfigList } from '@/webPublic/one_stop_public/publicServices';
import prepareShow from '@/webPublic/one_stop_public/Table/prepareShow';
import { queryApiVersion } from '@/webPublic/one_stop_public/utils/queryConfig';
import { getOneStopMyInfo } from '@/webPublic/one_stop_public/utils/utils';

// 根据模板code查询模板数据
// 查询表格中某条数据
// 查询元数据表格分页数据
// 根据元数据id查询表头
// 新增或者编辑表格某条数据
// 删除元数据中的数据

/**
 * 根据模板code查询模板数据
 * @param {String} code 模板的code
 */
export const fetchTemplateByCode = (code) =>
	uaaRequest('/UnifiedServicePatternApi/getDetail', { code });

export const fetchTemplateById = (id) =>
	uaaRequest('/UnifiedAppApi/getDetail', { id }).then((res) => {
		return prepareShow(res).then((x) => {
			return res;
		});
	});

/**
 * 查询表格中某条数据
 * @param {String} dataObjId 元数据id
 * @param{String} key 元数据表格中键
 * @param{String} value 元数据表格中键对应的值
 * @param{Bool} isBase key是否base加密过，默认传true
 */
export const fetchTableItem = ({ dataObjId, key, value, isBase = true }) => {
	return uaaRequest('/DataObjApi/getFormData', {
		dataObjId,
		key,
		value,
		isBase,
	});
};

/**
 * 查询元数据表格分页数据
 * @param {String} dataObjId 元数据表格id
 * @param {Object} query 过滤条件，传对象
 * @param {Number} pageSize
 * @param {Number} pageNo
 */
export const fetchTableData = ({ dataObjId, query, pageSize, pageNo, ...other }) => {
	return uaaRequest('/DataObjApi/getFormDataPage', {
		dataObjId,
		query: JSON.stringify(query),
		pageNo,
		pageSize,
		...other,
	});
};

/**
 * 根据元数据id查询表头
 * @param {String} objId 元数据id
 */
export const fetchTableHeader = (objId) =>
	uaaRequest('/DataColumnApi/getHeaderList', { dataObjId: objId });

/**
 * 删除元数据中的数据
 * @param {String} objId 元数据表格Id
 * @param {primaryKey} primaryKey 主键
 * @param {String} value 主键对应的值，删除多条数据时传数组
 */
export const deleteTableItem = (objId, primaryKey, value) => {
	const copyValue = Array.isArray(value) ? value.join(',') : value;
	return uaaRequest('/DataObjApi/deleteFormData', {
		objId,
		keys: JSON.stringify({ [primaryKey]: copyValue }),
	});
};

/**
 * 新增或者编辑表格某条数据
 * @param {String} objId 元数据表格id
 * @param {Object} data 传对象，新增或者修改的数据，
 * @param {Bool} isAdd true是新增，false是编辑
 * @param {Bool} isBase 数据是否编码过，从模板中出来的数据是编码过，默认true
 */
export const addOrEditTableItem = ({ objId, data, isAdd, isBase = true }) => {
	return uaaRequest('/DataObjApi/addFormData', {
		data: JSON.stringify(data),
		isAdd,
		objId,
		isBase,
	});
};

/**
 * 根据id或者code查询历史表单信息
 * @param {String} id 申报数据的id
 * @param {String} code 申报数据的code
 */
export const getHistoryFormDetail = (params = {}) => {
	return uaaRequest('/UnifiedAppFormApi/getFormDetail', params)
		.then((res) => {
			if (res) {
				// console.log(queryApiVersion());
				if (queryApiVersion() === '2.0') {
					// 2.0的接口 流程日志单独获取
					return api2_0_getTaskInfo(params).then((res2) => {
						return {
							...res,
							...res2,
						};
					});
				} else {
					return res;
				}
			} else {
				return null;
			}
		})
		.then((g) => {
			// console.log(g);
			return g;
		});
};

export const api2_0_getTaskInfo = (params = {}) => {
	return uaaRequest('/UnifiedAppFormApi/getFormNextUser', params).then((res) => {
		if (res) {
			return res;
		} else {
			return {};
		}
	});
};

export const getTaskDefinition = (data) => {
	return uaaRequest('/UnifiedAppFormApi/getTaskDefinition', data);
};

/**
 * 获取一站式应用列表
 * 用于授权
 */
export const getAppList = (params = {}) => {
	return uaaRequest('/UnifiedAppApi/getListByTree', params);
};

/**
 *
 * 用于一站式 应用分类列表 tree
 */
export const getAppTypeList = () => {
	return uaaRequest('/UnifiedAppGroupApi/getList', {});
};

/**
 *
 * 用于一站式 应用树形列表 tree
 */
export const getListByTreeList = (params = {}) => {
	return uaaRequest('/UnifiedAppApi/getListByTree', params);
};
export { getOneStopMyInfo };

export function getOneStopActiveMenus(key) {
	return new Promise((resolve, reject) => {
		setOneStopActiveMenusConfig('');
		resolve(true);
	});
}

export function getOnestopKey(key = '', formKey = 'key_list', formValue = 'value_list') {
	getOneStopActiveMenus().then((res) => {});
	if (config.getOnestopAppIdByMyPath) {
		getOneStopConfigList();
		if (key) {
			getOneStopConfig(key);
		}
	} else {
		return fetchTableData({
			dataObjId: config.onestopConfigDataObjId || '1248169933162938368',
			pageNo: 1,
			pageSize: 5000,
		}).then((x) => {
			if (x && x.rows && x.rows.length) {
				const onestopConfigList = {};
				for (const item of x.rows) {
					onestopConfigList[item[formKey]] = item[formValue];
				}
				setOneStopConfig(onestopConfigList);

				getOneStopConfigList();

				if (key) {
					return onestopConfigList[key];
				}
			} else {
				console.error('没有配置一站式相关服务,无法使用部分功能');
				return false;
			}
		});
	}
}

export function getWaitIds(params){
  return uaaRequest('/UnifiedAppFormApi/getWaitIds', params);
}
