import React, { useMemo } from 'react';
import { isJSON } from '@/webPublic/one_stop_public/copy';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';

export function checkAuth(authority) {
	let allAuth = localStorage.getItem('antd-pro-authority');
	allAuth = isJSON(allAuth) ? JSON.parse(allAuth) : null;
	if (!allAuth) {
		return false;
	}
	const path = localStorage.getItem('parentRoutePath');
	const checkPath = path + authority;
	console.log(checkPath,'checkPath');
	let findX = allAuth.find((g) => g === checkPath);
	return !!findX;
}

export default function Authorized(props) {
	const {
		authority, // /add
		children,
	} = props;
	const check = useMemo(
		() => {
			return checkAuth(authority);
		},
		[authority],
	);

	if (!check) {
		return null;
	}

	return children;
}
