/**
 * 审核按钮封装
 * 徐立
 * 2020-3-28
 * data 为 'affair/getIdFormDetail' 接口请求到的数据
 * callback 提交完成后执行回调函数
 * form form表单控件
 */
import React, { Component } from 'react';
import BtnOk from './userTable';
import { preHandle } from '../../utils/myutils';
import { connect } from 'dva';
@connect()
export default class index extends Component {
	constructor(props) {
		super(props);
		this.state = {
			isSumbitLoading: false,
			isHandle: false,
		};
	}
	affairOk = (oldkey, btnValue, value) => {
		const { dispatch, callback, data } = this.props;
		this.setState(
			{
				isSumbitLoading: true,
			},
			() => {
				this.props.form.validateFieldsAndScroll((err, values) => {
					if (!err) {
						preHandle(values);
						dispatch({
							type: 'affair/getExamineProcess',
							payload: {
								taskIds: [data.taskId], // 接口里面的taskId 任务Id
								code: data.code,
								// 审核相关内容
								examineMap: JSON.stringify({
									[oldkey]: btnValue, // 每个配置按钮对应的对象内容 oldkey = 接口中 key btnValue = 接口中 value
									reason: value, // 审批理由
									code: data.code,
								}),
								taskForm: JSON.stringify(values), // 审批表单的参数值
							},
							callback: (val) => {
								this.setState({
									isSumbitLoading: false,
									isHandle: false,
								});
								if (callback) {
									callback(val);
								}
							},
						});
					}
				});
			},
		);
	};
	componentDidMount() {
		const { data } = this.props;
		this.setState({
			isHandle: data.isHandle,
		});
	}
	componentWillReceiveProps(nextProps) {
		const { data } = nextProps;
		this.setState({
			isHandle: data.isHandle,
		});
	}
	render() {
		const { isSumbitLoading, isHandle } = this.state;
		const { data } = this.props;
		return (
			<>
				{isHandle ? (
					<BtnOk
						isSecond={data.isSecond}
						affairOk={this.affairOk}
						isSumbitLoading={isSumbitLoading}
						btns={data.btns}
					/>
				) : null}
			</>
		);
	}
}
