/**
 * 徐立
 * 2019年9月29日
 * 三次封装用户通过,驳回,拒绝状态
 * @param { jsx } addition 附件按钮 由外部添加
 */
import React, { Component } from 'react';
import { Input, Checkbox } from 'antd';
import Btn from '../pagesBtn';
import MyModal from '../Modal';
import styles from './styles.less';
import stylesList from './styles-in-line';
import { checkNeedFormValidateFieldsAndScroll } from '@/webPublic/one_stop_public/DetailForAudit/splitDetailSplit';

const { TextArea } = Input;
export default class userButton extends Component {
  constructor() {
    super();
    this.state = {
      // 路由位置
      visibleOk: false, // 通过模态框状态
      value: '', // 文本域输入
      user: '', // 用于保存用户点击了对应按钮
      returnText: '',
      key: '', // 后端返回按钮规格
      btnValue: '', // 后端返回按钮状态
      checked: '', // 是否使用签名
    };
  }

  /**
   * 通过按钮点击事件
   */
  showModal = (str, key, value) => {
    switch (str) {
      case '通过':
        this.setState({
          returnText: '已通过该申请！',
        });
        break;
      case '驳回':
        this.setState({
          returnText: '已驳回该申请！',
        });
        break;
      case '不通过':
        this.setState({
          returnText: '该申请未通过！',
        });
        break;
      case '提交':
        this.setState({
          returnText: '该申请已提交！',
        });
    }
    this.setState({
      user: str,
      visibleOk: true,
      key,
      btnValue: value,
    });
  };

  /**
   * 审核状态,返回对应样式html
   */
  getUser = () => {
    const { user } = this.state;
    switch (user) {
      case '通过':
        return <span style={{ color: '#31C93F' }}>{user}</span>;
      case '驳回':
        return <span style={{ color: '#FF9B00' }}>{user}</span>;
      case '拒绝':
        return <span style={{ color: '#FF5350' }}>{user}</span>;
      case '不通过':
        return <span style={{ color: '#FF5350' }}>{user}</span>;
      default:
        return <span>{user}</span>;
    }
  };

  /**
   * 通过按钮模态框取消状态
   */
  handleCancelOk = () => {
    this.setState({
      visibleOk: false,
    });
  };

  /**
   * 根据不同值,返回对应样式
   */
  getStyle = (key, value) => {
    if (key === 'examine') {
      switch (value) {
        case 1:
          return [`${styles.btn_margin}`, `${styles.btn}`, `${styles.btn_reject}`].join(' ');
        case 2:
          return [`${styles.btn_margin}`, `${styles.btn}`, `${styles.btn_no}`].join(' ');
        case 0:
          return 'deafalut';
        case '1':
          return [`${styles.btn_margin}`, `${styles.btn}`, `${styles.btn_reject}`].join(' ');
        case '2':
          return [`${styles.btn_margin}`, `${styles.btn}`, `${styles.btn_no}`].join(' ');
        case '0':
          return 'deafalut';
      }
    } else {
      return 'deafalut';
    }
  };

  /**
   * 用于确认用户输入
   */
  postUser = () => {
    const {
      key,
      btnValue,
      value,
      checked
    } = this.state;
    this.props.affairOk(key, btnValue, value, checked);
  };

  /**
   * 文本域同步
   */
  onChange = ({ target: { value } }) => {
    this.setState({ value });
  };

  /**
   * 判断是否使用自己的签名
   */
  onChange1 = (e) => {
    this.setState({ checked: e.target.checked });
  };

  checkAndShowModal(item = {}) {
    const {
      form,
      btns
    } = this.props;
    const showM = () => {
      this.showModal(item.name, item.key, item.value);
      return true;
    };
    if (form && form.validateFieldsAndScroll) {
      let checkSumbitInfo = checkNeedFormValidateFieldsAndScroll({ // 检查是否必须填写表单值
        btns,
        btnValue: item.value,
      });
      if (!checkSumbitInfo) { // 如果不需要校验 直接提交数据
         return showM();
      } else {
        form.validateFieldsAndScroll((err, values) => {
          if (!err) {
            return showM();
          }
        });
      }
    } else {
      return showM();
    }
  }

  render() {
    const {
      visibleOk,
      value,
      user
    } = this.state;
    const {
      btns,
      isSecond,
      isSumbitLoading,
      addition, // 附件按钮 只负责显示
      Sign, // 判断是否有签名
      form,
    } = this.props;

    return (
      <>
        <div className={styles.btn_page} id={'form_btns_list'}>
          {btns.length > 0
            ? btns.map((item, index) => {
              const className = this.getStyle(item.key, item.value);
              return (
                <Btn
                  get="8"
                  key={index}
                  btnOne={this.checkAndShowModal.bind(this, item)}
                  text={item.name}
                  style={className}
                />
              );
            })
            : ''}
          {addition && !isSumbitLoading && addition}
        </div>
        {/* <Btn get='2' btnOne={()=>{this.showModal('不同意')}} btnTwo={()=>{this.showModal('驳回')}} btnThree={()=>{this.showModal('通过')}}/> */}
        <MyModal
          visible={visibleOk}
          title={isSecond ? '重新发起' : '审批'}
          width={600}
          handleCancel={this.handleCancelOk}>
          <div style={stylesList.is_ok}>
            <p style={stylesList.header}>
							<span style={{ ...stylesList.headerSpan, ...stylesList.headerSpan_1 }}>
                {isSecond ? '当前状态' : '审批结果'}
							</span>
              {this.getUser()}
            </p>
            <div style={stylesList.body}>
							<span style={{ ...stylesList.body_span, ...stylesList.body_span_1 }}>
                {isSecond ? '发起说明' : '审批说明'}
							</span>
              <span id={'textarea_shen_pi_li_you'}>
								<TextArea
                  value={value}
                  onChange={this.onChange}
                  placeholder={isSecond ? '请输入发起说明' : '请输入审批理由'}
                  style={{
                    width: 380,
                    height: 120,
                    color: '#7F8B95'
                  }}
                />
							</span>
            </div>
            {Sign ? (
              <div style={stylesList.body}>
								<span style={{ ...stylesList.body_span, ...stylesList.body_span_1 }}>
                  使用签名
								</span>
                <span style={{ ...stylesList.body_span }}>
									<Checkbox defaultChecked={user.isUseBackImage} onChange={this.onChange1}/>
								</span>
              </div>
            ) : (
              ''
            )}
            <div style={{ marginBottom: 20 }}>
              <Btn
                get="4"
                isSumbitLoading={isSumbitLoading || false}
                btnOne={this.handleCancelOk}
                btnTwo={this.postUser}
              />
            </div>
          </div>
        </MyModal>
      </>
    );
  }
}
