import React, { Component, Fragment } from 'react';
import { Editor } from 'draft-js';
import { changeToDraftState } from '../utils/myutils';
import MyBlockRenderer from './MyBlockRender';
import moment from 'moment';
export default class DraftView extends Component {
	constructor(props) {
		super(props);

		this.setEditor = (editor) => {
			this.editor = editor;
		};

		this.focusEditor = () => {
			if (this.editor) {
				this.editor.focus();
			}
		};

		this.state = {
			editorState: changeToDraftState(this.props.currentObj.blocks),
		};
	}

	render() {
		const { currentUserId, currentObj, style, customHeader } = this.props;

		return (
			<div style={style}>
				{customHeader ? (
					customHeader
				) : (
					<div>
						<p style={{ fontSize: 20, textAlign: 'center' }}>{currentObj.title}</p>
						<p>
							发布时间:
							{currentObj.createTime
								? moment(currentObj.createTime).format('YYYY-MM-DD')
								: moment().format('YYYY-MM-DD')}
						</p>
					</div>
				)}
				<Editor
					key={currentUserId}
					readOnly={true}
					blockRendererFn={MyBlockRenderer.bind(this, true, currentUserId, null, null)}
					ref={this.setEditor}
					editorState={this.state.editorState}
				/>
			</div>
		);
	}
}
