import React, { useEffect, useState, useRef, useMemo } from 'react';
import { Progress, message } from 'antd';
import styles from './ImportUtil.less';
import { connect } from 'dva';
import { getServicesNomal } from '../Services/services';
import { importProcessApi } from '../Services/apiConfig';

function ProgressDiy(props) {
  const {
    importProcessUrl = '',
    fileCacheKey,
    changeOpenProgress = () => {
    },
  } = props;
  const interv = useRef();
  const [speedData, setData] = useState({ ...props });
  useEffect(() => {
    interv.current = setInterval(() => {
      getServicesNomal(importProcessUrl || importProcessApi, {
        cacheKey: fileCacheKey,
      }).then(res => {
        setData(res);
          if (res.finished) {
            clearInterval(interv.current);
            // message.success('导入完成');
            changeOpenProgress(false); // 导入成功
          }
      });
    }, 1000);
  }, []);

  const percent = useMemo(() => {
    const {
      success,
      total,
      fail,
    } = speedData;
    const r = success + fail;
    if (total === 0) {
      return 0;
    } else if (r > total) {
      return 100;
    }
    return Math.floor(r / total * 100);
  }, [speedData.success]);
  return (
    <div className={styles.juzhongSpin}>
      <div style={{ textAlign: 'center' }}>
        <Progress
          type="circle"
          strokeColor={{
            '0%': '#108ee9',
            '100%': '#87d068',
          }}
          percent={percent}
          status={speedData.finished ? 'success ' : 'active'}
          // format={percent => `${speedData.success + speedData.fail}/${speedData.total}`}
        />
        <div className={styles.textCenter}>
          正在处理导入数据: 共计 {speedData.total}条 已处理{speedData.success + speedData.fail}条.
          请勿关闭弹窗!
        </div>
      </div>
    </div>
  );
}

export default connect(({
                          DataObj,
                          loading
                        }) => ({
  DataObj,
}))(ProgressDiy);
