import Authorized from './Authorized';
import AuthorizedRoute from './AuthorizedRoute';
import Secured from './Secured';
import check from './CheckPermissions';
import renderAuthorize from './renderAuthorize';
import React from 'react';
import { connect } from 'dva';
import { querySysCode, queryCheckPath } from '../utils/queryConfig';
import { unwatchFile } from 'fs';

Authorized.Secured = Secured;
Authorized.AuthorizedRoute = AuthorizedRoute;
Authorized.check = check;
const RenderAuthorize = renderAuthorize(Authorized);
export default RenderAuthorize;

@connect(({ global }) => {
	const myPath = global.myPath || [];
	return { myPath: myPath };
})
class AuthorizedWarp extends React.PureComponent {
	render() {
		const isCheckPath = queryCheckPath();
		if (!isCheckPath) {
			return this.props.children;
		}
		const { myPath, ...props } = this.props;

		const MYAuthorized = RenderAuthorize(myPath);
		return <MYAuthorized {...props} />;
	}
}

export { AuthorizedWarp };
