import { apiRequest } from '@/webPublic/one_stop_public/utils/request';
import { isJSON } from '@/webPublic/zyd_public/utils/utils';
import baseX from 'base-x';
import encryptApiList from './encryptApiList';

var BASE16 = '0123456789abcdef';
var bs16 = baseX(BASE16);

function checkOpenBase16() {
	const is_open_base14 = sessionStorage.getItem('is_open_base16')
		? JSON.parse(sessionStorage.getItem('is_open_base16'))
		: false;
	return is_open_base14;
}

export function Base16Encode(value) {
	const is_open_base14 = checkOpenBase16();
	if (is_open_base14) {
		if (!value) {
			return null;
		} else {
			let newV = new Buffer(value); // 快
			const r = bs16.encode(newV); // 慢
			return r;
		}
	}
	return value;
}

function giveKey(key, datas) {
	if (datas && datas[key]) {
		datas[key] = Base16Encode(datas[key]);
	}
	return datas;
}

export async function countAllValues(datas, item) {
	if (item.setNull) {
		datas.allValues = JSON.stringify({});
	} else {
		if (item.query && !datas.isMeta) {
			if (datas?.sqlKey.length < 13) {
				const response = await apiRequest('/SqlManageEntityApi/findParamsKey', {
					sqlKey: datas.sqlKey,
				});
				if (!response || (Array.isArray(response) && response.length === 0)) {
					datas.allValues = JSON.stringify({});
				} else {
					const x = (isJSON(datas.allValues) && JSON.parse(datas.allValues)) || {};
					const y = {};
					for (let i of response) {
						if (x[i]) {
							y[i] = x[i];
						}
						datas.allValues = JSON.stringify(y);
					}
				}
			} else {
				datas.allValues = JSON.stringify({});
			}
		}
	}
	return datas;
}

export async function giveBase16EncodeAsync(datas, url) {

	if (url && typeof url === 'string') {
		for (const item of encryptApiList) {
			if (item.api && url.indexOf(item.api) > -1 && item.key) {
				for (let g of item.key) {
					// if (datas && datas[g] && item.filterEmpty && item.filterEmpty.includes(g)) {
						// 压缩代码功能暂时屏蔽
						/***
             // console.log(datas[g]);
             // console.log('%c加密数据压缩前字段' +  g + '= ', 'color: red;');
             // console.log('%c'+ datas[g] , 'color: red;');
             // datas[g] = datas[g].replace(/\r/g, ' ').replace(/\t/g, ' ').replace(/\n/g, ' ').replace(/\s\s+/g, ' ');
             // console.log('%c加密数据压缩后字段' +  g + '= ', 'color: orange;');
             // console.log('%c'+ datas[g] , 'color: orange;');
             ***/
					// }
					if (g === 'allValues' && typeof datas[g] !== 'undefined') { // 传了allValues时调用findParamsKey 接口 获取过滤参数
						datas = await countAllValues(datas, item); // 循环中 不要写await
						datas = giveKey('allValues', datas);
					} else {
						datas = giveKey(g, datas);
					}
				}

				if (item.yinShe) {
					// 映射参数字段.
					datas.isBase = true;
					for (let oldKey in item.yinShe) {
						let newKey = item.yinShe[oldKey];
						// if(typeof datas[oldKey] !== 'undefined'){
						datas[newKey] = datas[oldKey];
						delete datas[oldKey];
						// }
					}
				}
				return datas;
			}
		}
	}
	return datas;
}
