/**
 * @file 加签人列表展示
 */
import React, { Component } from 'react';
import styles from './styles.less';
import { Tag } from 'antd';
export default class ChildTaskModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isShow: false,
    };
  }
  /**
   * @function 加签展开状态
   * @event click
   */
  onStatusClick = () => {
    this.setState({
      isShow: !this.state.isShow,
    });
  };
  render() {
    const { isShow } = this.state;
    const { data } = this.props;
    return (
      <>
        <div className={styles.title_div}>
          <span className={styles.left_title_span}>加签人:</span>
          <a onClick={this.onStatusClick} className={styles.right_title_span}>
            {isShow ? '收起' : '展开'}
          </a>
        </div>
        {isShow && data && Array.isArray(data) ? (
          <div className={styles.ani_div}>
            {data.map((item, index) => {
              return (
                <div className={styles.card_div} key={index}>
                  <div>
                    加签人: <Tag color="#f50">{item.assignee}</Tag>
                  </div>
                  <div>审批状态: {item.status}</div>
                  {item.taskVariable && item.taskVariable.reason && (
                    <div>审批原因: {item.taskVariable.reason}</div>
                  )}
                </div>
              );
            })}
          </div>
        ) : null}
      </>
    );
  }
}
