/**
 * 钟是志
 * 拆分流程详情页面
 * 解决禅道bug 26569 审核详情中信息显示重复了
 * 2022年5月21日
 * 配置方法 在模板挂载前运行公式中返回
 *  window.zdyTableTemplateWillMountProps.detailCollapseProps = {
      defaultActiveKey: ['24a3dfc0-1829-4b0c-a7cc-a74baf20c89e'],
 * };
 * */
import React, { useRef, useState, useEffect, Fragment } from 'react';
import SVG from '@/webPublic/one_stop_public/DetailForAudit/components/SVG';
import { Form, Spin, Collapse, Icon } from 'antd';
import styles from './styles.less';
import ZdyTable from '@/webPublic/one_stop_public/Table';

const { Panel } = Collapse;
const customPanelStyle = {
  background: '#fff',
  borderRadius: 4,
  marginBottom: 24,
  border: 0,
  overflow: 'hidden',
};


export default function HistoryFormList({
                                          // isShowTitle = false,
                                          formKeys = [],
                                          data = {},
                                          routerState = {},
                                          formData,
                                        }) {


  if (!formKeys || !formKeys.length) {
    return null;
  }
  const detailCollapseProps = window.zdyTableTemplateWillMountProps?.detailCollapseProps || {};

  return (
    <Collapse bordered={false}
              defaultActiveKey={formKeys.map((g) => g.formKey)}
              expandIcon={({ isActive }) => <Icon type='caret-right' rotate={isActive ? 90 : 0} />}
              style={customPanelStyle}
              {...detailCollapseProps}
    >
      {Array.isArray(formKeys) && formKeys.length > 0 &&
      formKeys.map((item, index) => {
        return (
          <Panel header={<h3 className={styles.h3}

          >
            <SVG name='vertical' color='#999999' height='24' />
            {item?.taskName ?? '历史流程表单'}
          </h3>} key={item.formKey}>
            {!data ? (
              <div className={styles.div1}>
                <Spin size='large' spinning={true} />
              </div>
            ) : (
              <OldFromZdy
                key={item.formKey}
                get='web'
                taskId={data.taskId}
                postData={data}
                // obj={data && data.isMultiple ? item.taskForm : hisTaskFormKeys.formData}
                obj={data && data.isMultiple ? item.taskForm : formData}
                formKey={item.formKey}
                routerState={routerState}
              />
            )}
          </Panel>
        );
      })
      }
    </Collapse>
  );
}


/**
 * @function 历史表单展示
 * @description: 历史表单二次封装,独立form主要防止新表单进行输入时会同步刷新历史表单问题
 * @param {string}  key 模板key值
 * @param { any } postData 参数
 * @param { any } obj 默认值
 * @param { any } form form控件
 * @param { any } routerState 路由参数
 * @return: 渲染组件
 */

const OldFromZdy = Form.create()(function name({
                                                 key,
                                                 postData,
                                                 obj,
                                                 taskId,
                                                 form,
                                                 formKey,
                                                 routerState,
                                               }) {
  return (
    <ZdyTable
      key={key}
      get='web'
      postData={postData}
      taskId={taskId}
      obj={obj}
      form={form}
      formKey={formKey}
      routerState={routerState}
    />
  );
});
