import React from 'react';
import { Modal } from 'antd';
import classNames from 'classnames/bind';
import PortalFlowExamineModalContent from './Content';

const names = classNames.bind(require('./style.less'));

export default class PortalFlowExamineModal extends React.Component {
	state = { visible: false };

	showModal = () => {
		this.setState({ visible: true });
	};

	handleCancel = () => {
		this.setState({ visible: false });
	};

	render() {
		const { visible } = this.state;
		const { isShow, id, affairId } = this.props;
		const code = this.props?.code ? this.props?.code : '';
		return (
			<Modal
				title="事务流程"
				visible={visible}
				onCancel={this.handleCancel}
				footer={null}
				width={1300}
				wrapClassName={names('modal-warp')}
				destroyOnClose>
				<PortalFlowExamineModalContent affairId={affairId} id={id} code={code} isShow={isShow} />
			</Modal>
		);
	}
}
