## 一站式通用SVG库

##依赖环境

>```
>react
>```

## 使用示例

```jsx
import SVG from '@/SVG';
<SVG 
    name='leftArrows' // svg注册名
    width={20} // 宽度 20||"20"
    height={20} // 高度 20 || "20"
    mouseColor='blue' // 鼠标移入改变颜色,不传默认显示color颜色
    color='#888888' // 默认展示颜色
    />
```

## 注册新svg说明

前往iconfont网站选择图标

https://www.iconfont.cn/

选中图标后点击复制SVG

获取到以下代码

```html
<svg 
     t="1585207472508" 
     class="icon" 
     viewBox="0 0 1024 1024" 
     version="1.1" 
     xmlns="http://www.w3.org/2000/svg" 
     p-id="2142" 
     width="16" 
     height="16">
    <path 
          d="M1024 384 640 384 783.53 240.47C711 167.944 614.57 128 512 128 409.43 128 313 167.944 240.47 240.47 167.944 313 128 409.43 128 512 128 614.57 167.944 711 240.47 783.53 313 856.056 409.43 896 512 896 614.57 896 711 856.056 783.528 783.528 789.584 777.474 795.388 771.236 800.984 764.86L897.304 849.142C803.458 956.308 665.64 1024 512 1024 229.23 1024 0 794.77 0 512 0 229.23 229.23 0 512 0 653.386 0 781.368 57.326 874.016 149.984L1024 0 1024 384Z" 
          p-id="2143">
    </path>
</svg>
```

修改为以下代码后复制入SVG下index中进行注册

```jsx
<svg 
     t="1585207472508" 
     class="icon" 
     viewBox="0 0 1024 1024" 
     version="1.1" 
     xmlns="http://www.w3.org/2000/svg" 
     p-id="2142"                       
     width={width?width:"16"} // 动态配置宽度
     height={height?height:"16"} // 动态配置高度
     onMouseEnter={mouseEnterColor} // 移入方法
     onMouseLeave={mouseLeaveColor} // 移出方法
     style={{'cursor':'pointer'}} // 复制就行
    >
    <path 
          d="M1024 384 640 384 783.53 240.47C711 167.944 614.57 128 512 128 409.43 128 313 167.944 240.47 240.47 167.944 313 128 409.43 128 512 128 614.57 167.944 711 240.47 783.53 313 856.056 409.43 896 512 896 614.57 896 711 856.056 783.528 783.528 789.584 777.474 795.388 771.236 800.984 764.86L897.304 849.142C803.458 956.308 665.64 1024 512 1024 229.23 1024 0 794.77 0 512 0 229.23 229.23 0 512 0 653.386 0 781.368 57.326 874.016 149.984L1024 0 1024 384Z" 
        fill={ // 预先展示移入颜色,判断是否传入数组进行下标值分开获取,非数组直接展示
            showColor?
                Array.isArray(showColor)?
                showColor[0]
            :showColor
            :Array.isArray(color)?
                color[0]
            :color} 
          p-id="2143">
    </path>
</svg>
```