import React from 'react';
import { withPropsAPI } from 'gg-editor';
import { Card } from 'antd';

var allmasg = {
    "modelId": "85ca0dfc-26bc-11ea-b653-02424e738a18",
    "name": "流程名称zy1209659076275863552",
    "key": "zy1209659076275863552",
    "description": "",
    "lastUpdated": 1577695506731,
    "lastUpdatedBy": "admin",
    "model": {
        "modelId": "85ca0dfc-26bc-11ea-b653-02424e738a18",
        "bounds": {
            "lowerRight": {
                "x": 0,
                "y": 0
            },
            "upperLeft": {
                "x": 0,
                "y": 0
            }
        },
        "properties": {
            "process_id": "zy1209659076275863552",
            "name": "流程名称zy1209659076275863552",
            "documentation": "",
            "process_author": "",
            "process_version": "",
            "process_namespace": "http://www.flowable.org/processdef",
            "process_historylevel": "",
            "isexecutable": true,
            "dataproperties": "",
            "executionlisteners": "",
            "eventlisteners": "",
            "signaldefinitions": "",
            "messagedefinitions": "",
            "process_potentialstarteruser": "",
            "process_potentialstartergroup": "",
            "iseagerexecutionfetch": "false"
        },
        "childShapes": [],
        "stencil": {
            "id": "BPMNDiagram"
        },
        "stencilset": {
            "namespace": "http://b3mn.org/stencilset/bpmn2.0#",
            "url": "../editor/stencilsets/bpmn2.0/bpmn2.0.json"
        },
        "modelType": "model"
    }
}//结合节点和线

class GetDetail extends React.Component {
    get item() {
        const { propsAPI } = this.props;

        return propsAPI.getSelected()[0];
    }

    summary = (nodes, edges) => {//把节点和线结合起来
        if (edges.length > 0 && nodes.length > 0) {
            edges.map(item => {
                nodes = nodes.map(node => {
                    if (node.resourceId === item.source) {
                        node.outgoing.push({ "resourceId ": item.target })
                        return node
                    } else {
                        return node
                    }
                })
            })
            allmasg.model.childShapes = nodes
            this.props.getprocess(allmasg);
        }
    }


    allnodes = (itemMap) => {//把canvas中的信息分类
        // console.log(itemMap._nodes)
        const nodes = itemMap._nodes.map((item) => {
            // console.log(item.model)
            return item = {
                "resourceId": item.model.id,//组件的id
                "properties": {//组件的属性
                    "overrideid": "jd1",
                    "name": item.model.label,
                    "documentation": "",
                    "executionlisteners": "",
                    "initiator": "userId",
                    "formkeydefinition": "",
                    "formreference": "",
                    "formproperties": ""
                },
                "stencil": {
                    "id": item.model.shape
                },
                "childShapes": {//子类的组件
                },
                "outgoing": [],//要去的组件
                "bounds": {//组件的大小
                    "lowerRight": {//右下角
                        "x": Number(item.model.x) + Number(item.model.size.split("*")[0]),
                        "y": Number(item.model.y) + Number(item.model.size.split("*")[1])
                    },
                    "upperLeft": {//左上角
                        "x": Number(item.model.x),
                        "y": Number(item.model.y)
                    }
                },
                "dockers": []
            }
        })
        // console.log(nodes)

        //结合线条和节点
        if (itemMap._edges.length == 0) {
            allmasg.model.childShapes = nodes
            // console.log(allmasg)
        } else {
            this.summary(nodes, itemMap._edges)
        }
    }

    getNodeDetail = () => {
        const { form, propsAPI } = this.props;
        const { getSelected } = propsAPI;
        const { label } = this.item.getModel();
        const item = getSelected()[0];
        this.allnodes(item.itemMap)//信息分类
        // this.getDetail(item)
    }

    getEdgeDetail = () => {
        this.edgeInfo = this.item.getModel()
        // console.log(this.item)
        // this.addEdges(this.edgeInfo)
        this.allnodes(this.item.itemMap)//信息分类
    };
    getGroupDetail = () => {
        const { form } = this.props;
        const { label = 'æ–°å»ºåˆ†ç»„' } = this.item.getModel();
        console.log('group', this.item)
    };
    getCanvasDetail = () => {//点击canvas时运行的方法
        // console.log(1)
    }

    render() {
        const { type } = this.props;

        return (
            <Card type="inner" size="small" bordered={false}>
                {type === 'node' && this.getNodeDetail()}
                {type === 'edge' && this.getEdgeDetail()}
                {type === 'group' && this.getGroupDetail()}
                {type === 'canvas' && this.getCanvasDetail()}
            </Card>
        );
    }
}

export default withPropsAPI(GetDetail);

