import React, { Component } from 'react'
import { connect } from 'dva';

//引入dispath
@connect(({ DataGgEditor, loading }) => ({
    DataGgEditor,
    loading: loading.models.DataGgEditor,
}))

export default class GetProcess extends Component {
    constructor(props) {
        super(props)
        this.state = {
            data: {},
            value: this.props.value
        }
    }
    //请求自己需要的模板
    uplodeValueId = () => {
        if (event && event.target && event.target.value) {
            let value = event.target.value;
            this.setState(() => ({ value: value }), () => { this.getData() })
        }
    }
    getData = () => {//获取服务器的数据
        const { dispatch, value } = this.props;
        const valueId = this.state.value
        dispatch({
            type: 'DataGgEditor/fetch',
            payload: !!value ? value : '54791413-1c94-11ea-930a-525400e1d4cc',
            callback: (data) => {
                console.log(data)
                this.clearPrefix(data)
            }
        });
    }
    //清除前缀
    clearPrefix = (data) => {
        data.model.childShapes = data.model.childShapes.map(item => {
            if (item.resourceId.substring(0, 7) !== 'zysoft_') {
                return item
            }
            item.resourceId = item.resourceId.substring(7)
            if (item.outgoing.length > 0) {
                item.outgoing.map(goItem => {
                    goItem.resourceId = goItem.resourceId.substring(7)
                    return goItem
                })
            }
            if (item?.target) {
                item.target.resourceId = item?.target?.resourceId ? item?.target?.resourceId.substring(7) : ''
            }
            return item
        })
        this.deformation(data)
    }

    deformation = (data) => {//把服务器的数据转换为能展示的数据
        // console.log(data)
        const arr = {
            nodes: [],
            edges: []
        }
        data.model.childShapes.map(item => {
            if (item.stencil.id == "StartNoneEvent") {
                const obj = {
                    type: 'node',
                    size: '20*20',
                    shape: 'StartNoneEvent',
                    // color: '#FA8C16',
                    label: item?.properties?.name ? item.properties.name : '',
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "UserTask") {
                let obj = ''
                if (!!this.props.taskKeys && this.props.taskKeys.length > 0) {//判断是否有流程标记
                    this.props.taskKeys.map(taskItem => {
                        if (taskItem.substring(7) == item.resourceId) {
                            obj = {
                                type: 'node',
                                size: '60*48',
                                shape: 'UserTask',
                                // color: "#ffeae6",
                                tag: true,
                                label: item.properties.name,
                                x: item.bounds.upperLeft.x,
                                y: item.bounds.upperLeft.y,
                                id: item.resourceId,
                            }
                        } else {
                            obj = {
                                type: 'node',
                                size: '60*48',
                                shape: 'UserTask',
                                tag: false,
                                // color: "#ffeae6",
                                label: item.properties.name,
                                x: item.bounds.upperLeft.x,
                                y: item.bounds.upperLeft.y,
                                id: item.resourceId,
                            }
                        }
                    })
                } else {
                    obj = {
                        type: 'node',
                        size: '60*48',
                        shape: 'UserTask',
                        // color: "#ffeae6",
                        label: item.properties.name,
                        x: item.bounds.upperLeft.x,
                        y: item.bounds.upperLeft.y,
                        id: item.resourceId,
                    }
                }

                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "SequenceFlow") {
                data.model.childShapes.map(edge => {
                    edge.outgoing.map(dome => {
                        if (dome.resourceId == item.resourceId) {
                            // console.log(item.target.resourceId)
                            let staticValue = item?.properties?.conditionsequenceflow?.expression?.staticValue
                            const obj = {
                                source: edge.resourceId,
                                target: item.target.resourceId,
                                label: item.properties.name,
                                index: 1,
                                id: item.resourceId,
                                shape: "flow-polyline",
                                overrideid: item.properties.overrideid,
                                conditions: staticValue ? staticValue : '',
                                style: {
                                    lineWidth: 4,//连线的宽度
                                    // stroke: '#DDDDDD'//定义边的颜色
                                },
                                static: undefined,
                                controlPoints: [],
                                targetAnchor: item.properties.targetAnchor !== undefined ? item.properties.targetAnchor : '',
                                sourceAnchor: item.properties.sourceAnchor !== undefined ? item.properties.sourceAnchor : ''
                            }
                            arr.edges.push(obj)
                        }
                    })
                })
            } else if (item.stencil.id == "EndNoneEvent") {
                const obj = {
                    type: 'node',
                    size: '20*20',
                    shape: 'EndNoneEvent',
                    // color: '#FA8C16',
                    label: item.properties.name,
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "ExclusiveGateway") {
                const obj = {
                    type: 'node',
                    size: '20*20',
                    shape: 'ExclusiveGateway',
                    // color: 'blue',
                    label: item.properties.name,
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "BoundaryTimerEvent") {
                const obj = {
                    type: 'node',
                    size: '20*20',
                    shape: 'BoundaryTimerEvent',
                    // color: '#FA8C16',
                    label: item.properties.name,
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            }

        })
        this.setState({
            data: arr,
        }, () => {
            // console.log(this.state.data, data)
            // console.log(this.props)
            // const obj = {
            //     source: "startEvent1",
            //     target: "sid-6EE74761-4EAD-43E9-84CC-4CD5478A47F1",
            //     label: "第二步",
            //     index: 1,
            //     id: "fdgdsgdg",
            //     shape: "MyEdge",
            //     overrideid: "",
            //     conditions: "",
            //     style: { lineWidth: 4 },
            //     static: undefined,
            //     controlPoints: [{ x: 200, y: 600 }],
            //     targetAnchor: 1,
            //     sourceAnchor: 1,
            // }
            // arr.edges.push(obj)
            // console.log(arr)
            this.props.getServerData(this.state.data, data)
        })
    }

    componentDidMount() {
        this.getData()
    }
    render() {
        return <></>
    }
}
