import React, { Component } from 'react'
import { RegisterNode, RegisterEdge } from 'gg-editor';

class NewItem extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup();
                const model = item.getModel();
                const width = 100;//展示宽度
                const height = 80;//展示高度
                // console.log(65856852)
                const x = -width / 2;
                const y = -height / 2;
                const borderRadius = 10;//圆角
                const keyShape = group.addShape('rect', {
                    attrs: {
                        x,
                        y,
                        width,
                        height,
                        radius: borderRadius,
                        fill: 'white',//默认填充色
                        stroke: model?.tag ? 'red' : '#CED4D9',//默认边框颜色
                        lineWidth: 2,
                    }
                });

                // // 左侧色条
                // group.addShape('path', {
                //     attrs: {
                //         path: [//绘制图形
                //             ['M', x, y + borderRadius],
                //             ['L', x, y + height - borderRadius],
                //             ['A', borderRadius, borderRadius, 0, 0, 0, x + borderRadius, y + height],
                //             ['L', x + borderRadius, y],
                //             ['A', borderRadius, borderRadius, 0, 0, 0, x, y + borderRadius],
                //         ],
                //         fill: 'black',
                //     },
                // });


                // 类型 logo
                // group.addShape('image', {
                //     attrs: {
                //         img: textImg,//放入到框架的图片
                //         x: x + 16,
                //         y: y + 12,
                //         width: 20,
                //         height: 16,
                //     },
                // });

                // 名称文本

                let label = model.label ? model.label : this.label;
                if (label?.length > 5 && label?.length <= 10) {
                    label = label.slice(0, 5) + '\n' + label.slice(5)
                    console.log(label)
                } else if (label?.length > 10) {
                    label = label.slice(0, 5) + '\n' + label.slice(5, 10) + '\n' + label.slice(10)
                    console.log(label)
                }
                group.addShape('text', {
                    attrs: {
                        text: label,
                        x: x - x / 2,
                        y: y - y / 2,
                        textAlign: 'start',//文本对齐方式
                        textBaseline: 'top',//文本的基线对齐
                        fill: 'rgba(0,0,0,0.65)',
                    },
                });
                return keyShape;//draw方法返回的图形
            },

            // 设置锚点
            anchor: [
                [0.5, 0], // 上面边的中点
                [0.5, 1], // 下边边的中点
                [0, 0.5],
                [1, 0.5]
            ],
        }
        return (
            <RegisterNode name="UserTask" config={config} />
        );

    }
}
class BPMN extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup();
                const model = item.getModel();
                const width = 500;//展示宽度
                const height = 500;//展示高度
                const x = -width / 2;
                const y = -height / 2;
                const borderRadius = 10;//圆角
                const keyShape = group.addShape('rect', {
                    attrs: {
                        x,
                        y,
                        width,
                        height,
                        radius: borderRadius,
                        fill: 'white',
                        stroke: '#CED4D9',
                    },
                });

                // 左侧色条
                group.addShape('path', {
                    attrs: {
                        path: [//绘制图形
                            ['M', x, y + borderRadius],
                            ['L', x, y + height - borderRadius],
                            ['A', borderRadius, borderRadius, 0, 0, 0, x + borderRadius, y + height],
                            ['L', x + borderRadius, y],
                            ['A', borderRadius, borderRadius, 0, 0, 0, x, y + borderRadius],
                        ],
                        fill: 'black',
                    },
                });

                return keyShape;//draw方法返回的图形
            },
        }
        return (
            <RegisterNode name="BPMN" config={config} />
        );
    }
}
class StartNoneEvent extends React.Component {
    render() {
        const config = {
            draw(item) {
                console.log(7523)
                const group = item.getGraphicGroup();
                const model = item.getModel();
                // console.log(65856852)
                const x = 5;
                const y = 5;
                const r = 20;//圆角
                const keyShape = group.addShape('circle', {
                    attrs: {
                        x,
                        y,
                        r,
                        fill: 'white',
                        stroke: '#CED4D9',
                        lineWidth: 2
                    },
                });

                const label = model.label ? model.label : this.label;
                //文字
                group.addShape('text', {
                    attrs: {
                        text: label,
                        x: -10,
                        y: -5,
                        textAlign: 'start',//文本对齐方式
                        textBaseline: 'top',//文本的基线对齐
                        fill: 'rgba(0,0,0,0.65)',
                    },
                });

                return keyShape;//draw方法返回的图形
            },
            anchor: [
                [0.5, 0], // 上面边的中点
                [0.5, 1], // 下边边的中点
                [0, 0.5],
                [1, 0.5]
            ],
        }
        return (
            <RegisterNode name="StartNoneEvent" config={config} />
        );
    }
}
class EndNoneEvent extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup();
                const model = item.getModel();
                // console.log(4578574)
                const x = 0;
                const y = 0;
                const r = 20;//圆角
                const keyShape = group.addShape('circle', {
                    attrs: {
                        x,
                        y,
                        r,
                        fill: 'white',
                        stroke: '#CED4D9',
                        lineWidth: 3
                    },
                });

                const label = model.label ? model.label : this.label;
                //文字
                group.addShape('text', {
                    attrs: {
                        text: label,
                        x: -10,
                        y: -5,
                        textAlign: 'start',//文本对齐方式
                        textBaseline: 'top',//文本的基线对齐
                        fill: 'rgba(0,0,0,0.65)',
                    },
                });

                return keyShape;//draw方法返回的图形
            },
            anchor: [
                [0.5, 0], // 上面边的中点
                [0.5, 1], // 下边边的中点
                [0, 0.5],
                [1, 0.5]
            ],
        }
        return (
            <RegisterNode name="EndNoneEvent" config={config} />
        );
    }
}

class BoundaryTimerEvent extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup();
                const model = item.getModel();
                // model.x = model.x - 42
                // model.y = model.y - 42
                // console.log(15465)
                const x = 0;
                const y = 0;
                const r = 20;//圆角
                const keyShape = group.addShape('circle', {
                    attrs: {
                        x,
                        y,
                        r,
                        fill: 'white',
                        stroke: '#CED4D9',
                        lineWidth: 2
                    },
                });

                const label = model.label ? model.label : this.label;
                //文字
                group.addShape('text', {
                    attrs: {
                        text: label,
                        x: -10,
                        y: -5,
                        textAlign: 'start',//文本对齐方式
                        textBaseline: 'top',//文本的基线对齐
                        fill: 'rgba(0,0,0,0.65)',
                    },
                });

                return keyShape;//draw方法返回的图形
            },
            anchor: [
                [0.5, 0], // 上面边的中点
                [0.5, 1], // 下边边的中点
                [0, 0.5],
                [1, 0.5]
            ],
        }
        return (
            <RegisterNode name="BoundaryTimerEvent" config={config} />
        );
    }
}

class Erroy extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup();
                const model = item.getModel();
                const x = 40;
                const y = 40;
                const r = 20;//圆角
                const keyShape = group.addShape('circle', {
                    attrs: {
                        x,
                        y,
                        r,
                        fill: 'blue',
                    },
                });


                return keyShape;//draw方法返回的图形
            },
            anchor: [
                [0.5, 0], // 上面边的中点
                [0.5, 1], // 下边边的中点
                [0, 0.5],
                [1, 0.5]
            ],
        }
        return (
            <RegisterNode name="erroy" config={config} />
        );
    }
}
//网关
class ExclusiveGateway extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup()
                const model = item.getModel();
                // model.x = model.x - 30
                // model.y = model.y - 30
                const keyShape = group.addShape('polygon', {
                    attrs: {
                        points: [
                            [30, 0],
                            [60, 30],
                            [30, 60],
                            [0, 30]
                        ],
                        symbol: 'diamond',
                        fill: '#cccccc'
                    },
                });
                const label = model.label ? model.label : this.label;
                //文字
                group.addShape('text', {
                    attrs: {
                        text: label,
                        x: 15,
                        y: 22,
                        textAlign: 'start',//文本对齐方式
                        textBaseline: 'top',//文本的基线对齐
                        fill: 'rgba(0,0,0,0.65)',
                    },
                });
                return keyShape;
            },
            anchor: [
                [0.5, 0], // 上面边的中点
                [0.5, 1], // 下边边的中点
                [0, 0.5],
                [1, 0.5]
            ],
        }
        return <RegisterNode name="ExclusiveGateway" config={config} />
    }
}
//自定义线
class MyEdge extends React.Component {
    render() {
        const config = {
            draw(item) {
                const group = item.getGraphicGroup()
                const model = item.getModel();
                // console.log('我的边', item)
                const label = model.label ? model.label : this.label;
                let startX = ''
                let startY = ''
                let endX = ''
                let endY = ''
                let sourceAnchor = model.sourceAnchor
                let targetAnchor = model.targetAnchor
                if (model?.source?.x && model?.target?.x) {
                    console.log(1)
                    startX = model.source.x
                    startY = model.source.y
                    endX = model.target.x
                    endY = model.target.y
                } else if (!model?.source?.x && !model?.target?.x) {
                    console.log(2)
                    item.itemMap._nodes.map(item => {
                        if (item.id == model.source) {
                            startX = item._anchorPoints[sourceAnchor].x
                            startY = item._anchorPoints[sourceAnchor].y
                        }
                        if (item.id == model.target) {
                            endX = item._anchorPoints[targetAnchor].x
                            endY = item._anchorPoints[targetAnchor].y
                        }
                    })
                } else if (!model?.source?.x && model?.target?.x) {
                    endX = model.target.x
                    endY = model.target.y
                    item.itemMap._nodes.map(item => {
                        if (item.id == model.source) {
                            startX = item._anchorPoints[sourceAnchor].x
                            startY = item._anchorPoints[sourceAnchor].y
                        }
                    })
                } else if (model?.source?.x && !model?.target?.x) {
                    startX = model.source.x
                    startY = model.source.y
                    item.itemMap._nodes.map(item => {
                        if (item.id == model.target) {
                            endX = item._anchorPoints[targetAnchor].x
                            endY = item._anchorPoints[targetAnchor].y
                        }
                    })
                }
                // console.log(startX)
                const keyShape = group.addShape('path', {
                    attrs: {
                        lineWidth: 4,
                        startArrow: false,
                        endArrow: {
                            path: 'M 0,0 L 12,6 L 9,0 L 12,-6 Z',
                            fill: '#F6BD16',
                        },
                        stroke: "#A3B1BF",
                        strokeStyle: "#A3B1BF",
                        path: [
                            ["M", startX, startY],
                            ["L", model.controlPoints[0].x, model.controlPoints[0].y],
                            ["L", endX, endY],
                        ],
                    },
                });
                //文字
                group.addShape('text', {
                    attrs: {
                        text: label,
                        x: model.controlPoints[0].x,
                        y: model.controlPoints[0].y,
                        textAlign: 'start',//文本对齐方式
                        textBaseline: 'top',//文本的基线对齐
                        fill: 'black',
                    },
                });
                return keyShape;
            }
        }
        return <RegisterEdge name="MyEdge" config={config} />
    }
}

export {
    NewItem,
    BPMN,
    StartNoneEvent,
    EndNoneEvent,
    BoundaryTimerEvent,
    ExclusiveGateway,
    Erroy,
    MyEdge
};

