/**
 * 转办+回收弹框
 * 徐立
 * 2020.4.8
 * @param { boolean } visible model层显示控制变量
 * @param { Function } handleCancel model层关闭控制函数
 * @param { string } status 状态栏 存在以下状态 撤回 转办 回退
 * @param { any } value 当前表单数据
 * @param { Function } init 重置提交后数据源
 */
import React, { Component } from 'react';
import { Modal  } from 'antd';
import TrunTo from './trunTo';
import Recycle from './recycle';
import styles from './style.less';
import { confirm,openToast } from '../Notification';
import { connect } from 'dva';
import { getUaaServicesNomal } from '../../../Services/services';
import { refuseProcessApi, resetProcessApi, turnsProcessApi } from '../../../Services/apiConfig';
@connect()
export default class TurnToModel extends Component {
    constructor(props){
        super(props)
        this.state = {
            reason : '', // 用户相关原因同步,
            user: '', // 用户选择移交人数据
            loading: false, // 提交状态
        }
    }
    /**
     * 同步用户选择移交用户数据
     * @param { any } user 选中用户
     */
    asyncUser = (user) => {
        this.setState({
            user
        })
    }
    /**
     * 同步用户移交理由
     * @param { string } value 输入值
     */
    asyncReasion = (value) => {
        this.setState({
            reason: value
        })
    }
    /**
     * 用于不同状态提交
     */
    handleOk = async () => {
        const { status,dispatch,value } = this.props
        const { reason } = this.state
        await this.setState({
            loading: true
        })
        if(status === '转办'){ // 发起转办提交处理
            const { user } = this.state
            if(user){
                getUaaServicesNomal(turnsProcessApi, {
                    taskIds:[value.taskId],
                    reason,
                    turnsUserCode: user.stuNo
                }).then(() => {
                    openToast('success', '成功','当前流程已成功移交')
                    this.props.init()
                    this.setState({
                        loading: false
                    })
                })
            } else {
                openToast('info','错误','请选择移交人员')
            }
        } else if(status === '回退') { // 发起回退提交处理
            getUaaServicesNomal(refuseProcessApi, {
                taskIds:[value.taskId],
                reason
            }).then(() => {
                openToast('success', '回退','当前流程已成功回退')
                this.props.init()
                this.setState({
                    loading: false
                })
            });
        } else {
            console.log('缺乏匹配字段提交方法')
        }
        this.props.handleCancel()
    }
    recallConfim = () => {
        const { status,dispatch,value } = this.props
        confirm('撤回','是否撤回当前转办流程',()=>{
            getUaaServicesNomal(resetProcessApi, {
                taskIds:[value.taskId],
            }).then(() => {
                openToast('success','成功','该转办流程已成功撤回')
                this.props.init()
            });
            this.props.handleCancel()
        },()=>{
            this.props.handleCancel()
        })
    }
    render() {
        const {
            visible,
            handleCancel,
            status,
            value,
        } = this.props
        const {
            loading
        } = this.state
        if(visible){
            switch (status) {
                case '撤回':
                    this.recallConfim()
                    return <></>
                case '转办':
                    return <Modal
                                title={status}
                                visible={visible}
                                onOk={this.handleOk}
                                onCancel={handleCancel}
                                width={800}
                                loading={loading}
                            >
                                <div
                                    className={styles.model_div}
                                    >
                                        <TrunTo
                                            asyncReasion={this.asyncReasion}
                                            asyncUser={this.asyncUser}
                                            value={value}
                                            />
                                </div>
                            </Modal>
                case '回退':
                    return <Modal
                                title={status}
                                visible={visible}
                                onOk={this.handleOk}
                                onCancel={handleCancel}
                                width={800}
                                loading={loading}
                            >
                                <div
                                    className={styles.model_div}
                                    >
                                        <Recycle
                                            asyncReasion={this.asyncReasion}
                                            value={value}
                                            />
                                </div>
                            </Modal>
                default:
                    console.log('缺乏匹配项')
                    return <></>
            }
        } else {
            return <></>
        }
    }
}
