/**
 * 转办组件
 * 徐立
 * 2020.4.8
 * @param { Function } asyncUser 选择用户同步函数
 * @param { Function } asyncReasion 转交理由同步参数
 */
import React, { Component } from 'react';
import { Input, Table, Row, Col, Tooltip, Spin } from 'antd';
import styles from '../style.less';
import { connect } from 'dva';
import { getUaaServicesNomal } from '../../../../Services/services';
import { getListApi } from '../../../../Services/apiConfig';
const { Search } = Input;
const { TextArea } = Input;
@connect()
export default class index extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: [], // 表格参数
      checkedUser: '', // 用户选择参数
      textAreaValue: '', // 用户转发理由
      current: 1, // 当前页数
      pageSize: 10, // 每页条数
      total: 0, // 数据总数
      realname: '', // 姓名输入框输入值
      username: '', // 账号输入框输入值
      userData: '', // 回退数据
      isLoading: false, // 请求状态
    };
    this.columns = [
      {
        title: '工号',
        dataIndex: 'stuNo',
        width: 170,
      },
      {
        title: '用户名',
        dataIndex: 'realname',
        width: 170,
      },
      {
        title: '邮箱',
        dataIndex: 'email',
        width: 200,
        render: text => {
          return (
            <Tooltip title={text}>
              <div className={styles.table_post_name}>{text}</div>
            </Tooltip>
          );
        },
      },
      {
        title: '职位',
        dataIndex: 'mainPostName',
        render: text => {
          return (
            <Tooltip title={text}>
              <div className={styles.table_post_name}>{text}</div>
            </Tooltip>
          );
        },
      },
    ];
  }
  componentDidMount() {
    this.setState(
      {
        isLoading: true,
      },
      () => {
        this.getInit();
      },
    );
  }
  getInit = async () => {
    const { dispatch, value } = this.props;
    // 用户名列表
    await dispatch({
      type: 'uaa_User_OneStop/fetch',
      payload: {
        pageNo: 1,
        pageSize: 5,
      },
      callback: val => {
        this.setState({
          data: val.rows,
          current: val.pageNo,
          total: val.totalPage,
          pageSize: val.pageSize,
        });
      },
    });
    await getUaaServicesNomal(getListApi, {
      taskId: value.taskId,
    }).then(val => {
      this.setState({
        userData: Array.isArray(val) && val?.length > 0 ? val[val.length - 1] : '',
      });
    });
    await this.setState({
      isLoading: false,
    });
  };
  userPaginationChange = value => {
    const { dispatch } = this.props;
    const { realname, username } = this.state;
    // 用户名列表
    dispatch({
      type: 'uaa_User_OneStop/fetch',
      payload: {
        pageNo: value,
        pageSize: 5,
        realname,
        username,
      },
      callback: val => {
        this.setState({
          data: val.rows,
          current: val.pageNo,
          total: val.totalPage,
          pageSize: val.pageSize,
        });
      },
    });
  };
  /**
   * 根据名字查询
   * @param { string } value 用户输入值
   */
  searchNameChange = value => {
    const { dispatch } = this.props;
    dispatch({
      type: 'uaa_User_OneStop/fetch',
      payload: {
        pageNo: 1,
        pageSize: 5,
        realname: value,
      },
      callback: val => {
        this.setState({
          data: val.rows,
          current: val.pageNo,
          total: val.totalPage,
          pageSize: val.pageSize,
        });
      },
    });
  };
  /**
   * 名字输入事件
   * @param { stirng } e 用户输入事件
   */
  onNameChange = e => {
    this.setState({
      realname: e.target.value,
      username: '',
    });
  };
  /**
   * 根据账号查询
   * @param { stirng } value 用户输入值
   */
  serachStuNoChange = value => {
    const { dispatch } = this.props;
    this.setState({
      username: value,
    });
    dispatch({
      type: 'uaa_User_OneStop/fetch',
      payload: {
        pageNo: 1,
        pageSize: 5,
        username: value,
      },
      callback: val => {
        this.setState({
          data: val.rows,
          current: val.pageNo,
          total: val.totalPage,
          pageSize: val.pageSize,
        });
      },
    });
  };
  /**
   * 账号输入数据
   * @param { stirng } e 用户输入事件
   */
  onStuNoChange = e => {
    this.setState({
      username: e.target.value,
      realname: '',
    });
  };
  /**
   * 表格选择事件
   */
  tableChange = (selectedRowKeys, selectedRows) => {
    this.setState(
      {
        checkedUser: selectedRows?.[0] ?? '',
      },
      () => {
        this.props.asyncUser(this.state.checkedUser);
      },
    );
  };
  /**
   * 表格默认选择配置
   */
  getCheckboxProps = record => {
    return {
      disabled: record.name === 'Disabled User', // Column configuration not to be checked
      name: record.name,
    };
  };
  /**
   * 多行文本输入
   */
  textAreaChange = e => {
    this.setState({
      textAreaValue: e.target.value,
    });
    this.props.asyncReasion(e.target.value);
  };
  render() {
    const {
      data,
      checkedUser,
      current,
      total,
      pageSize,
      realname,
      username,
      userData,
      isLoading,
    } = this.state;
    const rowSelection = {
      onChange: this.tableChange,
      type: 'radio',
      fixed: true,
      // getCheckboxProps: this.getCheckboxProps,
    };
    let allWidth = 0;
    // 计算滑动总长度
    if (Array.isArray(this.columns)) {
      this.columns.map((item, index) => {
        if (this.columns.length - 1 === index) {
          // 为最后一个元素时跳过
          allWidth += 270; // 自适应200宽度
          return item;
        }
        if (item.width) {
          // 存在默认宽度
          allWidth += item.width;
        } else {
          // 不存在
          allWidth += 170;
        }
        return item;
      });
    }
    return (
      <>
        {!isLoading ? (
          <>
            <Row>
              <Col span={12}>
                <Row>
                  <Col
                    span={4}
                    style={{
                      minHeight: 32,
                      textAlign: 'right',
                      lineHeight: '32px',
                    }}
                  >
                    姓名 &nbsp;
                  </Col>
                  <Col span={20}>
                    <Search
                      placeholder="姓名"
                      value={realname}
                      onSearch={this.searchNameChange}
                      onChange={this.onNameChange}
                      enterButton
                    />
                  </Col>
                </Row>
              </Col>
              <Col span={12}>
                <Col
                  span={4}
                  style={{
                    minHeight: 32,
                    textAlign: 'right',
                    lineHeight: '32px',
                  }}
                >
                  账号 &nbsp;
                </Col>
                <Col span={20}>
                  <Search
                    placeholder="账号"
                    value={username}
                    onSearch={this.serachStuNoChange}
                    onChange={this.onStuNoChange}
                    enterButton
                  />
                </Col>
              </Col>
            </Row>
            <div id="trun_to_table" className={styles.trun_to_table_div}>
              <Table
                rowSelection={rowSelection}
                columns={this.columns}
                dataSource={data}
                scroll={{ x: allWidth }}
                pagination={{
                  hideOnSinglePage: true,
                  pageSize,
                  total,
                  current,
                  onChange: this.userPaginationChange,
                }}
              />
            </div>
            {checkedUser ? (
              <div className={styles.show_checked_user_div}>
                <Row gutter={16}>
                  <Col
                    span={4}
                    style={{
                      textAlign: 'right',
                    }}
                  >
                    转发人:
                  </Col>
                  <Col span={20}>{checkedUser.realname}</Col>
                </Row>
                <Row
                  gutter={16}
                  style={{
                    marginTop: 12,
                  }}
                >
                  <Col
                    span={4}
                    style={{
                      textAlign: 'right',
                    }}
                  >
                    转发原因:
                  </Col>
                  <Col span={20}>
                    <TextArea
                      rows={4}
                      style={{
                        resize: 'none',
                      }}
                      onChange={this.textAreaChange}
                    />
                  </Col>
                </Row>
              </div>
            ) : null}
            {userData && (
              <div
                className={styles.show_checked_user_div}
                style={{
                  marginTop: 12,
                }}
              >
                <Row gutter={16}>
                  <Col
                    span={4}
                    style={{
                      textAlign: 'right',
                    }}
                  >
                    回退人:
                  </Col>
                  <Col span={20}>
                    {userData?.receiveUserName ?? '暂无'}
                    {/* {checkedUser.realname} */}
                  </Col>
                </Row>
                <Row
                  gutter={16}
                  style={{
                    marginTop: 12,
                  }}
                >
                  <Col
                    span={4}
                    style={{
                      textAlign: 'right',
                    }}
                  >
                    回退原因:
                  </Col>
                  <Col span={20}>{userData?.massage}</Col>
                </Row>
              </div>
            )}
          </>
        ) : (
          <div className={styles.spin_div}>
            <Spin />
          </div>
        )}
      </>
    );
  }
}
