/**
 * 转办详情卡片
 * 徐立
 * 2020-4-14
 * @param { any } data 当前表单数据
 * @param { any } item 当前节点数据
 */
import React, { Component } from 'react';
import styles from './styles.less';
import SVG from './components/SVG';
import { Spin, Timeline,Icon } from 'antd';
import { connect } from 'dva';
import moment from 'moment';
import { getUaaServicesNomal } from '../Services/services';
import { getListApi } from '../Services/apiConfig';
@connect()
export default class trunToDetail extends Component {
    constructor(props){
        super(props)
        this.state = {
            trunToData: '',
            isUnfold: false,
            isLoading: false,
        }
    }
    /**
     * 切换状态函数
     */
    updateUnfold = () => {
        this.setState({
            isUnfold:!this.state.isUnfold,
        },async () => {
            const { isUnfold } = this.state
            const { dispatch,item } = this.props
            if(isUnfold){ // 判断当前是否为展开状态
                await this.setState({
                    isLoading: true,
                })
                // 发起请求获取数据
                getUaaServicesNomal(getListApi, { taskId: item.id }).then(val => {
                    this.setState({
                        isLoading: false,
                        trunToData: val
                    });
                });
            } else { // 为关闭状态清空数据
                this.setState({
                    trunToData: ''
                })
            }
        })
    }
    render() {
        const {
            trunToData,
            isUnfold,
            isLoading,
        } = this.state
        // console.log(import.meta)
        return (
            <>
            <div
                className={styles.steps_body}
                style={{
                    display:'flex'
                }}
                >
                转办流程
                <span
                    className={styles.steps_span}
                    onClick={this.updateUnfold}
                        >
                    {
                        isUnfold?
                            <>
                            收起
                            <SVG
                                name='packUp'
                                color='#1890FF'
                                />
                            </>
                            :<>
                                展开
                                <SVG
                                    name='unfold'
                                    color='#1890FF'
                                    />
                                </>
                    }
                </span>
            </div>
            {
                isUnfold?
                    isLoading?
                        <div
                            style={{
                                textAlign:'center'
                            }}
                            >
                            <Spin />
                        </div>
                        :<div
                            className={styles.ani_css}
                            style={{
                                marginTop:32
                            }}
                            >
                            <Timeline>
                                {trunToData !== ''
                                ? trunToData.map((item, index) => {
                                    if (index == trunToData.length - 1) {
                                    return (
                                        <Timeline.Item
                                        color={"#ccc"}
                                        dot={<Icon type={"clock-circle-o"}
                                            style={{ fontSize: '16px' }} />}
                                        className={styles.steps_step}
                                        key={item.id}
                                        >
                                        <p>
                                            转办人:{item?.sendUserName??'暂无'}
                                        </p>
                                        <p className={styles.steps_body}>
                                            转办时间:{item?.createTime?moment(+item.createTime).format('YYYY-MM-DD HH:MM'):'暂无'}
                                        </p>
                                        <p>
                                            接办人:{item?.receiveUserName??'暂无'}
                                        </p>
                                        <p className={styles.steps_body}>
                                            移交理由:{item?.receiveUserName??'暂无'}
                                        </p>
                                        </Timeline.Item>
                                    );
                                    }
                                    return (
                                    <Timeline.Item
                                        color={'green'}
                                        dot={<Icon type="check-circle" theme="twoTone" twoToneColor="#52c41a" />
                                        }
                                        className={styles.steps_step}
                                        key={item.id}
                                    >
                                        <p>
                                            转办人:{item?.sendUserName??'暂无'}
                                        </p>
                                        <p className={styles.steps_body}>
                                            转办时间:{item?.createTime?moment(+item.createTime).format('YYYY-MM-DD HH:MM'):'暂无'}
                                        </p>
                                        <p>
                                            接办人:{item?.receiveUserName??'暂无'}
                                        </p>
                                        <p className={styles.steps_body}>
                                            移交理由:{item?.massage??'暂无'}
                                        </p>
                                    </Timeline.Item>
                                    );
                                })
                                : ''}
                            </Timeline>
                        </div>
                    :null
            }
            </>
        )
    }
}
