/**
 钟是志
 学工里面的流程申请页面不再使用iframe
 2022年5月26日 13:41:08

 * */

import React from 'react';
import classNames from 'classnames/bind';
import { connect } from 'dva';
import SponsorForm from './SponsorForm/index';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';
import { setToken } from '@/webPublic/one_stop_public/utils/token';
import { getUaaServicesNomal } from '../Services/services';
import { getAllApi } from '../Services/apiConfig';

const names = classNames.bind(require('./style.less'));

/**
 * props:{
 *     id, // 流程id
      init, //  表单的初始化数据 用于发起时传入默认值 需要转码 详见  constructor
      noNeedApply, // 不需要申请提交按钮
      noNeedTitle, // 不需要标题
 * }
 * */


@connect(({
            affair,
            modileHome,
          }) => ({
  affair,
  modileHome,
}))
export default class IframeForApply extends React.Component {
  constructor(props) {
    super(props);

    const { token } = getUrlInfo();
    if (token) {
      setToken(token);
    }
    const {
      id,
      init,
      noNeedApply,
      noNeedTitle,
    } = props;
    this.state = {
      id, // 传入id
      init: init || undefined,
      // 2022年8月9日 发起页面的默认值可以通过这个init 传进来
      value: '', // 紧急度选择
      btnList: [], // 紧急度按钮返回数据
      noNeedApply,
      noNeedTitle,
    };
    this.nodeChild = null;
  }

  componentDidMount() {
    getUaaServicesNomal(getAllApi, {}).then(val => {
      this.setState({
        btnList: val,
        value: val[val.length - 1].id,
      });
    });
    // document.getElementById('root').style.backgroundColor = '#fff';
  }

  onChange = e => {
    this.setState({
      value: e.target.value,
    });
  };

  setRadio = value => {
    this.setState({
      value,
    });
  };

  testGoBack = () => {
    this.props.returnList(true);
  }

  render() {
    const {
      id,
      value,
      init,
      noNeedApply,
      noNeedTitle,
    } = this.state;
    const { modileHome, returnList } = this.props;
    return (
      <div
        className={names('warp IframeDiy')}
        id='tabsTableFromIframe'
        style={{
          overflowY: 'auto',
          height: '100%',
        }}
      >
        {!noNeedTitle && (
          <h1 style={{
            fontWeight: 'bold',
            textAlign: 'center',
          }}>
            {modileHome?.affair?.name ? modileHome?.affair.name : modileHome?.affair?.appName}
          </h1>
        )}
        {/*<Button onClick={this.testGoBack}>123</Button>*/}
        <div className={names('content-container')}>
          <div style={{ padding: '0 24px 24px' }}>
            <div style={{ minHeight: 569 }}>
              <SponsorForm
                id={id}
                setRadio={this.setRadio}
                returnList={returnList}
                radioValue={value}
                noNeedApplyButton={noNeedApply}
                init={init} // 表单的初始化数据 用于发起时传入默认值
                history={{
                  ...this.props.history,
                  location: {
                    ...this.props.history.location,
                    state: {
                      id,
                      noNeedCaoGao: true,
                      app: {},
                    },
                  },
                }}
              />
            </div>
          </div>
        </div>
      </div>
    );
  }
}
