import { apiRequest, uaaRequest } from '../utils/request';
import { importExecuteApi, getFormDataPageApi } from './apiConfig'

// apiRequest
export const getServicesNomal = (apiAddress, params) => {
	return apiRequest(apiAddress, params);
};

// uaaRequest
export const getUaaServicesNomal = (apiAddress, params) => {
	return uaaRequest(apiAddress, params);
};

export const getFormDataPage = (params) => {
	return apiRequest(getFormDataPageApi, params).then((response) => {
		if (response) {
			return {
				list: response.rows,
				pagination: {
					current: response.pageNo,
					pageSize: response.pageSize,
					total: response.total,
				},
			};
		}
	});
};

export const importExecute = (params) => {
	return apiRequest(importExecuteApi, {
		...params,
		customErrMsg:
			'导入的文件中可能存在字段不一致、字段类型不匹配、唯一性字段冲突,请检查或联系系统管理员',// 自定义errMsg
	});
};

export const importExecute2 = (params) => {
  return apiRequest('/UnifiedAppFormApi/importExecute', {
    ...params,
    customErrMsg:
      '导入的文件中可能存在字段不一致、字段类型不匹配、唯一性字段冲突,请检查或联系系统管理员',// 自定义errMsg
  });
};


export const decodeObjKey = (code) => {
  return apiRequest('/SnowflakeUtilApi/decode', {
    code,
  });
};
