// 保存签名 到用户基础信息上
import { getUserInfo } from '@/webPublic/one_stop_public/utils/token';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';
import { getOneStopMyInfo } from '@/webPublic/one_stop_public/utils/utils';

export function saveSign(url) {
  if (typeof url !== 'string' || url.length < 15) {
    return true;
  }
  const userInfo = getUserInfo();
  uaaRequest('/UserApi/saveMySysBackgroundImage', {
    username: userInfo.stuNo,
    backgroundImageUrl: userInfo.backgroundImageUrl || 'fakeBackgroundImageUrl', // 假数据
    isUseBackImage: userInfo.isUseBackImage || false,
    userSign: url,
  }).then((g) => {
    getOneStopMyInfo();
    return true;
  });
}

export function dataURLtoBlob(toDataURL) {
  var arr = toDataURL.split(','),
    mime = arr[0].match(/:(.*?);/)[1],
    bstr = atob(arr[1]),
    n = bstr.length,
    u8arr = new Uint8Array(n);
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n);
  }
  return new Blob([u8arr], { type: mime });
}

export function blobToFile(Blob, fileName) {
  Blob.lastModifiedDate = new Date();
  Blob.name = fileName;
  return Blob;
}
