/**
 * 徐立
 * 2019年9月25日
 * 自定义表单表格
 */
import React, { Component } from 'react';
import { Form, Row, Col, Input, message } from 'antd';
import UUID from 'react-native-uuid';
import { Toast } from 'antd-mobile';
import router from 'umi/router';
import moment from 'moment';
import { HyperFormula } from 'hyperformula';
import TableCom from '../tableCompon';
import IsNewTable from './isNewMobileTable';
import maintain from '../assets/maintain.png';
import { isJSON } from '@/webPublic/one_stop_public/copy';
import getActiveJson from '@/webPublic/one_stop_public/Table/getActiveJson';

export default class ZdyTable extends Component {
  constructor(props) {
    super(props);
    // console.log(props);
    this.state = {
      objRealTime: {},
      isChange: false,
      selects: new Map(),
      left: 0,
      top: 0,
      max: 4,
      formId: null,
      formCode: null,
      width: 100,
      mapData: {},
      defaultBinds: {},
      sqlData: {},
      defaultValues: {},
      currentFormKey: null,
      currentFormTitle: null,
      items: [],
      init: this.props.init || {},
      datas: {},
      isEdit: true,
      isRowCol: false,
      isReady: false,
      formConfig: {},
    };
  }

  componentDidMount() {
    const {
      postData, // 数据源
      isCg, // 用户点击草稿页面进入
      isForm,
      isPreview, // 是否为预览模式
      isChild, // 是否为子表单
      isQRCode = false, // 是否为二维码快捷发起
      formDeafault = '', // 为二维码快捷发起默认值
    } = this.props;

    if (isPreview || isChild) {
      this.initExcel(
        {
          datas: this.props.datas,
          trees: this.props.trees,
        },
        () => {
          this.setState({
            ...this.state,
            ...this.props,
            formConfig: {
              ...this.state.formConfig,
              style: this.props.style,
            },
            isReady: true,
            viewMode:
              this.props.currentFormKey &&
              this.props.datas &&
              this.props.datas[this.props.currentFormKey]
                ? this.props.datas[this.props.currentFormKey].viewMode
                : null,
          });
        },
      );

      return;
    }

    const val = postData;
    // console.log(val);
    // debugger;
    try {
      /**
       * 数据源不同进行以下区别处理
       * this.props.table有传入值表明需要渲染流程中最新表单
       */
      if (isForm) {
        // 由表格的操作按钮进入

        const mapData = {};
        const sqlData = {};
        const dataObjs = val.form.dataObjModels;
        for (var i = 0; i < dataObjs.length; i++) {
          const dob = dataObjs[i];
          for (var j = 0; j < dob.columnModels.length; j++) {
            mapData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const sqls = val.form.sqlModels;
        for (var i = 0; i < sqls.length; i++) {
          const dob = sqls[i].dataObjModel;
          for (var j = 0; j < dob.columnModels.length; j++) {
            sqlData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const obj = JSON.parse(val.form.content);
        const xxx = obj.datas[obj.init];
        const fk = this.props.table ? val.formKey : obj.init;
        this.initExcel(obj, () => {
          this.setState({
            datas: obj.datas,
            width: this.props.table ? obj.datas[val.formKey].width : xxx.width,
            isBorder: this.props.table ? obj.datas[val.formKey].isBorder : xxx.isBorder,
            viewMode: this.props.table ? obj.datas[val.formKey].viewMode : xxx.viewMode,
            isRowCol: this.props.table ? obj.datas[val.formKey].isRowCol : xxx.isRowCol,
            mapData,
            currentFormKey: fk,
            currentFormTitle: this.getCurrentFormTitle(obj, fk),
            sqlData,
            isEdit: !this.props.formKey,
            items: this.props.table ? obj.datas[val.formKey].items : xxx.items,
            defaultValues: val.form.defaultValues,
            appId: val.appId,
            isReady: true,
            formConfig: xxx,
          });
        });

        return;
      }
      if (isCg === 'yes') {
        // 用户从编辑按钮进入
        if (
          val.unifiedServicePatternModel.isDefaultError != null &&
          val.unifiedServicePatternModel.isDefaultError
        ) {
          if (this.props.get === 'web') {
            message.error('当前办理人数较多，服务繁忙，请稍后再试!');
          } else {
            Toast.fail('当前办理人数较多，服务繁忙，请稍后再试!');
          }

          router.goBack();
          return;
        }
        const mapData = {};
        const sqlData = {};
        const sqls = val.unifiedServicePatternModel.sqlModels;
        for (var i = 0; i < sqls.length; i++) {
          const dob = sqls[i].dataObjModel;

          for (var j = 0; j < dob.columnModels.length; j++) {
            sqlData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const dataObjs = val.unifiedServicePatternModel.dataObjModels;
        for (var i = 0; i < dataObjs.length; i++) {
          const dob = dataObjs[i];

          for (var j = 0; j < dob.columnModels.length; j++) {
            mapData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const obj = JSON.parse(val.unifiedServicePatternModel.content);

        const xxx = obj.datas[obj.init];
        this.initExcel(obj, () => {
          this.setState({
            items: xxx.items,
            init: { ...this.state.init, ...JSON.parse(val.content) },
            datas: obj.datas,
            isEdit: !this.props.formKey,
            currentFormKey: obj.init,
            currentFormTitle: this.getCurrentFormTitle(obj, obj.init),
            width: xxx.width,
            isBorder: xxx.isBorder,
            viewMode: xxx.viewMode,
            isRowCol: xxx.isRowCol,
            mapData,
            sqlData,
            defaultValues: val.unifiedServicePatternModel.defaultValues,
            appId: val.appId,
            isReady: true,
            formConfig: xxx,
            defaultBinds: this.props.table
              ? obj.datas[val.taskFormKey].defaultBinds
              : xxx.defaultBinds,
          });
        });

        return;
      }

      if (
        val.unifiedServicePatternModel.isDefaultError != null &&
        val.unifiedServicePatternModel.isDefaultError
      ) {
        if (this.props.get == 'web') {
          message.error('当前办理人数较多，服务繁忙，请稍后再试!');
        } else {
          Toast.fail('当前办理人数较多，服务繁忙，请稍后再试!');
        }
        router.goBack();
        return;
      }

      const mapData = {};
      const sqlData = {};
      const sqls = val.unifiedServicePatternModel.sqlModels;
      for (var i = 0; i < sqls.length; i++) {
        const dob = sqls[i].dataObjModel;

        for (var j = 0; j < dob.columnModels.length; j++) {
          sqlData[dob.columnModels[j].base52] = dob.columnModels[j];
        }
      }
      const dataObjs = val.unifiedServicePatternModel.dataObjModels;
      for (var i = 0; i < dataObjs.length; i++) {
        const dob = dataObjs[i];

        for (var j = 0; j < dob.columnModels.length; j++) {
          mapData[dob.columnModels[j].base52] = dob.columnModels[j];
        }
      }
      if (!isJSON(val.unifiedServicePatternModel.content)) {
        console.error('unifiedServicePatternModel.content 不是一个JSON字符串 请查看配置');
      }
      const obj = JSON.parse(val.unifiedServicePatternModel.content);
      const xxx = obj.datas[this.props.formKey ? this.props.formKey : obj.init]; // 是否是存在历史表单传入值
      const fk = this.props.formKey
        ? this.props.formKey
        : val.taskFormKey
          ? val.taskFormKey
          : obj.init;
      // console.log('231--------');
      this.initExcel(obj, () =>
        this.setState(
          {
            appId: val.id,
            formId: val.id,
            formCode: val.code,
            datas: obj.datas,
            mapData,
            sqlData,
            defaultValues: val.unifiedServicePatternModel.defaultValues,
            isEdit: !this.props.formKey,
            currentFormKey: fk,
            currentFormTitle: this.getCurrentFormTitle(obj, fk),
            defaultBinds: this.props.table
              ? obj.datas[val.taskFormKey].defaultBinds
              : xxx.defaultBinds,
            width: this.props.table ? obj.datas[val.taskFormKey].width : xxx.width,
            isBorder: this.props.table ? obj.datas[val.taskFormKey].isBorder : xxx.isBorder,
            isRowCol: this.props.table ? obj.datas[val.taskFormKey].isRowCol : xxx.isRowCol,
            viewMode: this.props.table ? obj.datas[val.taskFormKey].viewMode : xxx.viewMode,

            items: this.props.table ? obj.datas[val.taskFormKey].items : xxx.items,
            isReady: true,
            init: { ...this.state.init, ...(val.isSecond ? this.props.obj : {}) }, // 重新发起就拿obj 里面的值给初始值
            formConfig: xxx,
            // init:this.props.get==="mobile"?!!val.content?JSON.parse(val.content):'':{},// 移动端默认值设置
          },
          () => {
            /**
             * 为二维码快捷发起时自动设置新默认值
             */
            if (isQRCode) {
              this.props.form.setFieldsValue(formDeafault);
            }
            this.initExcel(obj);
          },
        ),
      );
    } catch (e) {
      console.log('公式配置有误/Table/index-262', e);
    }
  }

  importExcel = (res, callback) => {
    if (this.props.importExcel) {
      this.props.importExcel(res, callback);
      return;
    }
    const {
      datas,
      trees,
    } = this.configs;
    const sheets = res.sheets;

    for (var s = 0; s < sheets.length; s++) {
      const uuid = sheets[s].key;
      const items = [];
      const cc = sheets[s].cells;
      for (var i = 0; i < cc.length; i++) {
        const rows = [];
        const rr = cc[i];
        for (var j = 0; j < rr.length; j++) {
          const c = rr[j];
          if (c.value == null || c.value == '') {
            rows.push({
              uuid: 'id_' + UUID.v4()
                .replace(/-/g, '2'),
              row: c.rowSpan,
              col: c.colSpan,
              content: {
                comName: 'Excel',
                cwidth: c.width,
                cheight: c.height,
              },
            });
          } else {
            rows.push({
              uuid: 'id_' + UUID.v4()
                .replace(/-/g, '2'),
              row: c.rowSpan,
              col: c.colSpan,
              content: {
                comName: 'Excel',
                initialValue: c.value,
                cwidth: c.width,
                cheight: c.height,
              },
            });
          }
        }
        items.push(rows);
      }

      const charts = sheets[s].charts;
      if (charts && charts.length > 0) {
        const rows = [];
        for (var j = 0; j < charts.length; j++) {
          const chartModel = charts[j];
          rows.push({
            uuid: 'id_' + UUID.v4()
              .replace(/-/g, '2'),
            content: {
              comName: 'Echart',
              columnIds: { c1: [] },
              labelSpan: 24,
              wrapperSpan: 24,
              isLabel: false,
              formula: 'return ' + JSON.stringify(chartModel.option),
            },
          });
          items.push(rows);
        }
      }
      if (datas[uuid] == null) {
        trees.push({
          title: sheets[s].name,
          key: uuid,
        });
      }
      datas[uuid] = {
        width: 400,
        max: 1,
        isBorder: true,
        items: items,
      };
    }
    this.initExcel(
      {
        datas,
        trees,
      },
      () => {
        this.setState({ isChange: !this.state.isChange }, () => {
          if (callback) callback();
        });

        console.log('公式导入excel成功');
      },
    );
  };

  hfInstance;
  childExcel = (sheetData, datas, tr) => {
    if (tr.children == null || tr.children.length == 0) {
    } else {
      for (var c = 0; c < tr.children.length; c++) {
        this.childExcel(sheetData, datas, tr.children[c]);
      }
    }
    const data = datas[tr.key];
    const all = [];
    if (data && data.item) {
      for (var i = 0; i < data.items.length; i++) {
        const row = data.items[i];
        const r = [];
        for (var j = 0; j < row.length; j++) {
          const col = row[j];
          if (col.content?.comName == 'Excel') {
            r.push(col.content.initialValue);
          } else {
            r.push('');
          }
        }
        all.push(r);
      }
    }

    sheetData[tr.title] = all;
  };
  configs;
  initExcel = (configs, callback) => {
    this.configs = configs;
    // console.log(configs);
    if (configs == null || configs.trees == null) {
      if (callback) callback();
      return;
    }

    const sheetData = {};
    for (var key in configs.trees) {
      const tr = configs.trees[key];
      this.childExcel(sheetData, configs.datas, tr);
    }
    const hfInstance = HyperFormula.buildFromSheets(sheetData, {});

    this.hfInstance = hfInstance;
    if (callback) callback();
  };
  getCellValue = (i, j, currentTitle) => {
    let hfInstance = this.props.hfInstance ? this.props.hfInstance : this.hfInstance;

    if (hfInstance && currentTitle) {
      let x = hfInstance.getCellValue({
        col: j,
        row: i,
        sheet: hfInstance.getSheetId(currentTitle),
      });

      if (x && x.value != null) {
        x = x.value;
      }
      return x;
    }
  };

  componentWillReceiveProps(nextProps) {
    const {
      postData, // 数据源
      isCg, // 用户点击草稿页面进入
      isForm,
      isPreview, // 是否为预览模式
      isChild, // 是否为子表单
    } = nextProps;
    if (isPreview || isChild) {
      this.setState(
        {
          ...this.state,
          ...nextProps,
          isReady: true,
          viewMode:
            nextProps.currentFormKey && nextProps.datas && nextProps.datas[nextProps.currentFormKey]
              ? nextProps.datas[nextProps.currentFormKey].viewMode
              : null,
          formConfig: {
            ...this.state.formConfig,
            style: nextProps.style,
          },
        },
        () =>
          this.initExcel({
            datas: nextProps.datas,
            trees: nextProps.trees,
          }),
      );
      return;
    }

    try {
      const val = postData;
      /**
       * 数据源不同进行以下区别处理
       * this.props.table有传入值表明需要渲染流程中最新表单
       */
      if (isForm) {
        // 由表格的操作按钮进入
        const mapData = {};
        const sqlData = {};
        const dataObjs = val.form.dataObjModels;
        for (var i = 0; i < dataObjs.length; i++) {
          const dob = dataObjs[i];
          for (var j = 0; j < dob.columnModels.length; j++) {
            mapData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const sqls = val.form.sqlModels;
        for (var i = 0; i < sqls.length; i++) {
          const dob = sqls[i].dataObjModel;
          for (var j = 0; j < dob.columnModels.length; j++) {
            sqlData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const obj = JSON.parse(val.form.content);
        const xxx = obj.datas[obj.init];
        this.initExcel(obj, () => {
          this.setState({
            datas: obj.datas,
            width: this.props.table ? obj.datas[val.formKey].width : xxx.width,
            isRowCol: this.props.table ? obj.datas[val.formKey].isRowCol : xxx.isRowCol,
            isBorder: this.props.table ? obj.datas[val.formKey].isBorder : xxx.isBorder,
            mapData,
            currentFormKey: this.props.table ? val.formKey : obj.init,
            currentFormTitle: this.getCurrentFormTitle(obj, fk),
            sqlData,
            isEdit: !this.props.formKey,
            items: this.props.table ? obj.datas[val.formKey].items : xxx.items,
            defaultValues: val.form.defaultValues,
            appId: val.appId,
            isReady: true,
            formConfig: xxx,
          });
        });

        return;
      }
      if (isCg === 'yes') {
        // 用户从编辑按钮进入
        const mapData = {};
        const sqlData = {};
        const sqls = val.unifiedServicePatternModel.sqlModels;
        for (var i = 0; i < sqls.length; i++) {
          const dob = sqls[i].dataObjModel;

          for (var j = 0; j < dob.columnModels.length; j++) {
            sqlData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const dataObjs = val.unifiedServicePatternModel.dataObjModels;
        for (var i = 0; i < dataObjs.length; i++) {
          const dob = dataObjs[i];

          for (var j = 0; j < dob.columnModels.length; j++) {
            mapData[dob.columnModels[j].base52] = dob.columnModels[j];
          }
        }
        const obj = JSON.parse(val.unifiedServicePatternModel.content);
        const xxx = obj.datas[obj.init];
        this.initExcel(obj, () => {
          this.setState({
            items: xxx.items,
            init: { ...this.state.init, ...JSON.parse(val.content) },
            datas: obj.datas,
            isEdit: !this.props.formKey,
            currentFormKey: obj.init,
            currentFormTitle: this.getCurrentFormTitle(obj, obj.init),
            width: xxx.width,
            isBorder: xxx.isBorder,
            isRowCol: xxx.isRowCol,
            mapData,
            sqlData,
            defaultValues: val.unifiedServicePatternModel.defaultValues,
            appId: val.appId,
            isReady: true,
            formConfig: xxx,
            defaultBinds: this.props.table
              ? obj.datas[val.taskFormKey].defaultBinds
              : xxx.defaultBinds,
          });
        });

        return;
      }
      const mapData = {};
      const sqlData = {};
      const sqls = val.unifiedServicePatternModel.sqlModels;
      for (var i = 0; i < sqls.length; i++) {
        const dob = sqls[i].dataObjModel;

        for (var j = 0; j < dob.columnModels.length; j++) {
          sqlData[dob.columnModels[j].base52] = dob.columnModels[j];
        }
      }
      const dataObjs = val.unifiedServicePatternModel.dataObjModels;
      for (var i = 0; i < dataObjs.length; i++) {
        const dob = dataObjs[i];

        for (var j = 0; j < dob.columnModels.length; j++) {
          mapData[dob.columnModels[j].base52] = dob.columnModels[j];
        }
      }
      const obj = JSON.parse(val.unifiedServicePatternModel.content);
      const xxx = obj.datas[this.props.formKey ? this.props.formKey : obj.init]; // 是否是存在历史表单传入值

      if (this.props.isQuery) return;
      const fk = this.props.formKey
        ? this.props.formKey
        : val.taskFormKey
          ? val.taskFormKey
          : obj.init;
      this.initExcel(obj, () => {
        this.setState({
          appId: val.id,
          datas: obj.datas,
          mapData,
          sqlData,
          defaultValues: val.unifiedServicePatternModel.defaultValues,
          isEdit: !this.props.formKey,
          currentFormKey: fk,
          currentFormTitle: this.getCurrentFormTitle(obj, fk),
          defaultBinds: this.props.table
            ? obj.datas[val.taskFormKey].defaultBinds
            : xxx.defaultBinds,
          width: this.props.table ? obj.datas[val.taskFormKey].width : xxx.width,
          isBorder: this.props.table ? obj.datas[val.taskFormKey].isBorder : xxx.isBorder,
          isRowCol: this.props.table ? obj.datas[val.taskFormKey].isRowCol : xxx.isRowCol,
          items: this.props.table ? obj.datas[val.taskFormKey].items : xxx.items,
          isReady: true,
          init: {
            ...this.state.init,
            ...(val.isSecond ? this.props.obj : {}),
          },
          formConfig: xxx,
          // init:this.props.get==="mobile"?!!val.content?JSON.parse(val.content):'':{},// 移动端默认值设置
        });
      });
    } catch (e) {
      console.log('公式配置有误Table/index.jsx/572', e);
    }
  }

  checkAllHidden = (row) => {
    for (var i = 0; i < row.length; i++) {
      if (row[i].hidden == null || !row[i].hidden) {
        return false;
      }
    }
    for (var i = 0; i < row.length; i++) {
      delete row[i].hidden;
    }
    return true;
  };

  countMax = (items) => {
    let max = 0;
    items.forEach((r) => {
      if (r.length > max) {
        max = r.length;
      }
    });
    return max;
  };
  getCurrentFormTitle = (obj, key) => {
    if (obj == null) return;
    const { trees } = obj;
    if (trees == null) return;
    return this.getT(trees, key);
  };
  getCurrentFormTitle2 = (key) => {
    if (this.configs == null) return;
    const trees = this.configs && this.configs.trees ? this.configs.trees : this.props.trees;
    if (trees == null) return;
    return this.getT(trees, key);
  };
  setRealTimeValues = (obj) => {
    this.setState({ objRealTime: obj });
  };
  getT = (trees, key) => {
    for (var i in trees) {
      if (trees[i].key == key) {
        return trees[i].title;
      }
      if (trees[i].children != null && trees[i].children.length > 0) {
        const x = this.getT(trees[i].children, key);
        if (x != null) return x;
      }
    }
    return null;
  };

  render() {
    const {
      width,
      isRowCol,
      isBorder,
      sqlData,
      mapData,
      defaultBinds,
      defaultValues,
      items,
      init,
      currentFormKey,
      currentFormTitle,
      isEdit,
      datas,
      isReady,
      formConfig,
      formCode,
      formId,
      viewMode,
    } = this.state;
    const {
      border,
      obj,
      index,
      fatherCode,
      routerState, // 场景设计器共享路由参数
      messageData, // 场景设计器共享变量参数 设计器监听到参数发生变化后会重新渲染组件
      postData,
      modalInit,
      concealModel, // 场景设计器内置跳转函数
      paddingBottom,
      taskAssignee,
      userId,
      isDynamic, // 是否为大数据页面
      isWebPrint, // 打印界面
      isWebPrintEnd,
      isPreview,
    } = this.props;
    const trees = this.configs && this.configs.trees ? this.configs.trees : this.props.trees;

    let get;
    if (viewMode != null && viewMode != '') {
      get = viewMode;
    } else {
      get = this.props.get;
    }
    let style = {};
    if (formConfig.style != null) {
      try {
        style = JSON.parse(formConfig.style);
      } catch (e) {
        //console.log(e);
        style = {};
      }
    }

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 24 },
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 24 },
      },
    };
    const max = this.countMax(items);
    const borderStyle = {
      borderRight: '1px solid gray',
      borderTop: '1px solid gray',
      borderLeft: '1px solid gray',
      borderBottom: '1px solid gray',
    };
    let updateTime;
    const styleDiv = this.props.height
      ? {
        overflow: isDynamic ? 'hidden' : 'auto',
        // overflowY: isDynamic && 'auto',
        width: '100%',
        height: this.props.height,
        paddingBottom: paddingBottom != null ? paddingBottom : isWebPrint ? 0 : '0px',
      }
      : {
        overflow: isDynamic ? 'hidden' : 'auto',
        // overflowY: isDynamic && 'auto',
        width: '100%',
        paddingBottom: paddingBottom != null ? paddingBottom : isWebPrint ? 0 : '0px',
      };

    if (!isReady) return <></>;
    if (this.props.postData?.isUpdate) {
      updateTime = moment(+this.props.postData?.updateTime)
        .format('llll');
    }
    switch (get) {
      case 'web':
        // this.props.form.validateFields()
        //   .then((values) => {
        //   })
        //   .catch(error => console.log(error));
        return (
          <>
            {this.props.postData?.isUpdate ? (
              <div style={{ margin: '100px 24px 24px' }}>
                <div style={{ textAlign: 'center' }}>
                  <img style={{ marginRight: 30 }} src={maintain} />
                </div>
                <p
                  style={{
                    textAlign: 'center',
                    width: '100%',
                    fontSize: '16px',
                    fontWeight: 'bold',
                    color: '#666666',
                  }}>
                  {updateTime !== 'Invalid date'
                    ? `升级维护中，预计${updateTime ?? '一万年'}恢复使用,请耐心等待。`
                    : '请耐心等待'}
                </p>
              </div>
            ) : (
              <div id='web_table' style={{...this.props?.currentFormStyle}}>
                <Form className='login-form'>
                  {isEdit && defaultBinds
                    ? Object.keys(defaultBinds)
                      .map((k) => {
                        const r = defaultBinds[k];
                        if (
                          r.columnIds == null ||
                          r.columnIds.length < 2 ||
                          r.sqls == null ||
                          r.sqls.length < 2
                        ) {
                          return '';
                        }
                        const name = r.columnIds[r.columnIds.length - 1];
                        const key = r.sqls[r.sqls.length - 1];
                        const value = defaultValues[key];

                        if (value === null || value === undefined) {
                          return '';
                        }

                        return this.props.form.getFieldDecorator(name, {
                          initialValue: value,
                        })(<Input type='hidden' />);
                      })
                    : ''}
                  <Row>
                    <Col span={24}>
                      <div
                        data-page-formkey={currentFormKey}
                        style={styleDiv}
                        ref={(ref) => {
                          this.root = ref;
                        }}>
                        <table
                          style={{
                            overflow: 'auto',
                            margin: max * width > 550 ? '1px auto' : '', // 禅道 27868
                            marginBottom: isWebPrint ? (isWebPrintEnd ? '5px' : 0) : '1px',
                            ...style,
                          }}
                          border={border}
                          cellSpacing='0'
                          cellPadding='0'>
                          <tbody>
                          {items.map((row, i) => {
                            const allhidden = this.checkAllHidden(row);
                            // console.log(row);
                            return (
                              <tr key={i}>
                                {row.map((cell, j) => {
                                  if (!cell.content) {
                                    return;
                                  }
                                  if (cell.uuid) {
                                    if (cell.content) {
                                      cell.content = {
                                        ...cell.content,
                                        ...getActiveJson(currentFormKey, cell.uuid),
                                      };
                                      if (window.zdyTableTemplateWillMountProps?.allDisabled) {
                                        cell.content.disabled = true;
                                      }
                                    }
                                    // 27282 双选会报名后管理员修改举办时间 但是单位申请信息么有随着更新
                                  }

                                  let styles = {};
                                  // console.log(cell.content);
                                  if (cell.content && cell.content.styles) {
                                    try {
                                      styles = JSON.parse(cell.content.styles);
                                    } catch (e) {
                                      console.log(`第${i}行第${j}列样式配置有误,${e}`);
                                    }
                                  }
                                  let cwidth = cell.content != null && cell.content.cwidth != null ? cell.content.cwidth : width;
                                  return (!allhidden && cell.hidden) || cell.content.isNoRender ? (
                                    ''
                                  ) : (
                                    <td
                                      width={
                                        isNaN(Number(cwidth)) ?  cwidth : cwidth * (cell.col ? cell.col : 1) 
                                      }
                                      rowSpan={cell.row}
                                      colSpan={cell.col}
                                      key={j}
                                      data-cell-id={
                                        cell.uuid || 'no_uuid_' + Math.random()
                                          .slice(0, 6)
                                      }
                                      data-com-name={cell.content?.comName || 'empty'}
                                      style={{
                                        overflow: 'auto',
                                        textAlign:
                                          cell.content && cell.content.calign
                                            ? cell.content.calign
                                            : 'left',
                                        ...(isBorder
                                          ? cell?.content?.comName === 'InputHidden' ||
                                          !cell?.content?.comName
                                            ? {}
                                            : borderStyle
                                          : {}),
                                        // position: cell.content&&cell.content.comName ==="InputHidden"&&'absolute',
                                        ...styles,
                                        display:
                                          cell.content &&
                                          (cell.content.comName === 'InputHidden' ||
                                            cell.content.isHidden) &&
                                          'none',
                                      }}>
                                        {/* 渲染对应的label */}
                                      <TableCom
                                        taskId={this.props.taskId}
                                        importExcel={this.importExcel}
                                        getCellValue={this.getCellValue}
                                        getCurrentFormTitle={this.getCurrentFormTitle2}
                                        hfInstance={this.hfInstance}
                                        isWebPrintEnd={isWebPrintEnd}
                                        isWebPrint={isWebPrint}
                                        isPrint={this.props.isPrint}
                                        formCode={formCode} // 当前表单code
                                        modalInit={modalInit}
                                        taskAssignee={taskAssignee} // 提交人
                                        userId={userId}
                                        formId={formId} // 当前表单Id
                                        i={i} // 当前组件下标
                                        j={j} // 当前行数下班
                                        isPreview={isPreview}
                                        fatherCode={fatherCode}
                                        index={index}
                                        fatherObj={this.props.fatherObj}
                                        datas={datas}
                                        uuid={cell.uuid}
                                        setRealTimeValues={this.setRealTimeValues}
                                        isEdit={isEdit}
                                        formKey={currentFormKey}
                                        currentFormTitle={currentFormTitle}
                                        init={init}
                                        get={get} // 区分移动端或wen端
                                        json={cell.content}
                                        obj={{ ...obj, ...this.state.objRealTime } || {}} // 是否存在默认值
                                        mapData={mapData}
                                        form={this.props.form} // antd form控件
                                        sqlData={sqlData}
                                        defaultValues={defaultValues || {}} // 接口中的默认值
                                        routerState={routerState} // 兼容表单设计器路由传参
                                        messageData={messageData} // 场景设计器共享变量参数
                                        concealModel={concealModel || {}} // 场景设计器内置路由跳转函数
                                        isDynamic={isDynamic} // 是否为场景配置器调用
                                        trees={trees}
                                      />
                                    </td>
                                  );
                                })}
                              </tr>
                            );
                          })}
                          </tbody>
                        </table>

                        {style.pageBreakAfter != null ? (
                          <div style={{ pageBreakAfter: style.pageBreakAfter }} />
                        ) : (
                          ''
                        )}
                      </div>
                    </Col>
                  </Row>
                </Form>
              </div>
            )}
          </>
        );
      case 'mobile':
        return (
          <>
            {this.props.postData?.isUpdate ? (
              <div style={{ margin: '100px 24px 24px' }}>
                <div style={{ textAlign: 'center' }}>
                  <img style={{ width: '100%' }} src={maintain} />
                </div>
                <p
                  style={{
                    textAlign: 'center',
                    width: '100%',
                    fontSize: '16px',
                    fontWeight: 'bold',
                    color: '#666666',
                  }}>
                  {updateTime !== 'Invalid date'
                    ? `升级维护中，预计${updateTime ?? '一万年'}恢复使用,请耐心等待。`
                    : '请耐心等待'}
                </p>
              </div>
            ) : (
              <Form {...formItemLayout} id='mobile_table' className='login-form'>
                {defaultBinds
                  ? Object.keys(defaultBinds)
                    .map((k) => {
                      const r = defaultBinds[k];
                      if (
                        r.columnIds == null ||
                        r.columnIds.length < 2 ||
                        r.sqls == null ||
                        r.sqls.length < 2
                      ) {
                        return '';
                      }
                      const name = r.columnIds[r.columnIds.length - 1];
                      const key = r.sqls[r.sqls.length - 1];
                      const value = defaultValues[key];

                      if (value === null || value === undefined) {
                        return '';
                      }

                      return this.props.form.getFieldDecorator(name, {
                        initialValue: value,
                      })(<Input type='hidden' />);
                    })
                  : ''}
                <IsNewTable
                  taskId={this.props.taskId}
                  getCellValue={this.getCellValue}
                  hfInstance={this.hfInstance}
                  getCurrentFormTitle={this.getCurrentFormTitle2}
                  taskAssignee={taskAssignee} // 提交人
                  userId={userId}
                  importExcel={this.importExcel}
                  isPreview={isPreview}
                  trees={trees}
                  setRealTimeValues={this.setRealTimeValues}
                  isRowCol={isRowCol}
                  modalInit={modalInit}
                  items={items}
                  checkAllHidden={this.checkAllHidden}
                  isBorder={isBorder}
                  borderStyle={borderStyle}
                  fatherCode={fatherCode}
                  index={index}
                  datas={datas}
                  isEdit={isEdit}
                  currentFormKey={currentFormKey}
                  currentFormTitle={currentFormTitle}
                  init={init}
                  get={get}
                  obj={{ ...obj, ...this.state.objRealTime }}
                  mapData={mapData}
                  form={this.props.form}
                  sqlData={sqlData}
                  defaultValues={defaultValues}
                  width={width}
                  formCode={formCode}
                  style={style}
                  routerState={routerState} // 兼容表单设计器路由传参
                  messageData={messageData} // 场景设计器共享变量参数
                  formId={formId}
                  fatherObj={this.props.fatherObj}
                  concealModel={concealModel || {}} // 场景设计器内置路由跳转函数
                  isDynamic={isDynamic} // 是否为场景配置器调用
                />
              </Form>
            )}
          </>
        );
    }
  }
}
