import React from 'react';
import moment from 'moment';
import {
  Modal,
  message,
  notification,
  Tooltip,
  Spin,
  Popover,
  Popconfirm,
  Tag,
  Badge,
  Input,
  InputNumber,
  Select,
  Checkbox,
  Radio,
  DatePicker,
  Switch,
} from 'antd';
import md5 from 'js-md5';
import { giveFilePostDataInfoForTrue } from '@/webPublic/one_stop_public/Base16';
import {
  getSpanJson,
  getColumns,
  getColumnsData,
  getCustomData,
  getColumnsDataRealize,
  getCustomDataRealize,
  getColumnsSqlKeyRealize,
  getCustomSqlKeyRealize,
  getWord,
  getFileAndShow,
  renderContentAll,
  renderContentRow,
  downloadFile,
  getListWord,
  upObjKey,
} from './globalFunction';
import getFilesToPdfAndShow from './getFilesToPdfAndShow';
import { getTransformApi } from '@/webPublic/one_stop_public/2022beidianke/localstorageTransform';

export function getSystemCode() {
  const systemCode = localStorage.getItem('antd-pro-type') || '';
  const exp = new RegExp('/*', 'mg');
  return systemCode.replace(exp, '');
}

export function giveSmartFormGlobalProps({
  fromStart = false, // 是否是 发起申请
  hasSingle = false,
  isHandle = false,
  onlyRead = false, // 是否此表单所有组件只读
  taskCells = [],
  data = {},
  nextUsers = {}, //
  calculateFlowData = [], // 移动端使用 用于分块块  禅道 23933 移动端全表单后审核步骤的显示问题优化
}) {
  window.smartFormGlobalProps = {
    fromStart,
    hasSingle,
    isHandle,
    taskCells,
    data,
    nextUsers,
    calculateFlowData,
    onlyRead,
    apiList: {
      giveFilePostDataInfoForTrue,
      getSpanJson,
      getColumns,
      getColumnsDataRealize,
      getCustomDataRealize,
      getColumnsData,
      getCustomData,
      getColumnsSqlKeyRealize,
      getCustomSqlKeyRealize,
      getWord,
      getFileAndShow,
      getListWord,
      downloadFile,
      renderContentAll,
      renderContentRow,
      getTransformApi,
      upObjKey,
      getFilesToPdfAndShow,
      md5,
      remark: {
        downloadFile: '下载文件函数.',
        'giveFilePostDataInfoForTrue(params, url) ': `将接口参数 二进制文件化 并返回新的接口地址与参数';`,
        'getSpanJson(mergeKey, data, eliminateStr)': `列表获取纵向合并数据 ;参数-> mergeKey : 需要合并的表头key data : 列表数据 eliminateStr : 需要忽略合并的数据`,
        'getColumns(columns)': `获取ant表头的属性 ;参数->columns : ant的表头`,
        'getColumnsData({data, mergeKey, columns, styles, defect, fileName, ext , eliminateStr})': `获取列表合并的数据;参数-> 前三个必填data, mergeKey, columns`,
        'getCustomData({data, mergeKey, columnsList,columnsMerges,columnsKey, styles, defect, fileName, ext , eliminateStr})': `获取列表合并的数据;参数-> 前五个个必填data, mergeKey, columnsList,columnsMerges,columnsKey`,
        'getColumnsDataRealize({data, mergeKey, columns, styles, defect, fileName, ext , eliminateStr})': `下载列表合并的数据;参数-> 前三个必填data, mergeKey, columns`,
        'getCustomDataRealize({data, mergeKey,columnsList ,columnsMerges,columnsKey,bottomList,bottomMerges, styles, defect, fileName, ext , eliminateStr})': `下载列表合并的数据;参数-> 前五个必填data, mergeKey,columnsList ,columnsMerges,columnsKey`,
        'getColumnsSqlKeyRealize({sqlKey, columns, styles, fileName, ext})': `下载列表表头合并的数据;参数->前两个必填sqlKey, columns`,
        'getCustomSqlKeyRealize({sqlKey, columnsList,columnsMerges,columnsKey, styles, fileName, ext})': `下载列表表头合并的数据;参数->前四个必填sqlKey, columnsList,columnsMerges,columnsKey`,
        'getWord({templatePath,params, title, allValues, listConfig, ext})': `下载文档地址 ;参数->前五个必填 templatePath,params, title, allValues, listConfig`,
        'getFileAndShow({templatePath,params, title, allValues, listConfig, ext})': `下载一个文件并直接展示出来地址 ;参数->前五个必填 templatePath,params, title, allValues, listConfig`,
        'getListWord({templatePath,paramsList, title,sonTitleKey, allValuesKey, listConfig, ext,sonExt})': `批量下载文档地址 ;参数->前五个必填 templatePath,paramsList, title,sonTitleKey, allValuesKey`,
        'renderContentAll(value, row, index, key, spanData, cloumnNames) ': `ant表头横向、纵向合并 ;参数->所有必填 value, row, index, key, spanData, cloumnNames 实例：render:(value, row, index)=>{return renderContentAll(value, row, index,"inst_name",spanData,cloumnNames)}`,
        'renderContentRow(value, row, index, key, spanData, cloumnNames) ': `ant表头纵向合并 ;参数->所有必填 value, row, index, key, spanData, cloumnNames 实例：render:(value, row, index)=>{return renderContentRow(value, row, index,"inst_name",spanData,cloumnNames)}`,
        'getFilesToPdfAndShow(dataList)':'将多个pdf 合并成一个pdf 用于预览 打印',
        getTransformApi: '接口转换函数用于一站式接口地址加密',
        'upObjKey({}/[{}],{lodKey:newKey})': '用于修改对象或数组对象KEY',
        md5: 'md5加密函数',
      },
    },
    activeJsonConfig: {}, // 27282 双选会报名后管理员修改举办时间 但是单位申请信息么有随着更新
    publicComponent: {
      React,
      Modal,
      message,
      notification,
      Tooltip,
      Spin,
      Popover,
      Popconfirm,
      moment,
      Tag,
      Badge,
      Input,
      InputNumber,
      Select,
      Checkbox,
      Radio,
      DatePicker,
      Switch,
    },
    routePath: window.location.href.split('#')[1],
    systemCode: getSystemCode(),
  };
  return true;
}
