import React from 'react';
import { Modal, message } from 'antd';
import { isJSON } from '@/webPublic/one_stop_public/copy';
import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';
import { deepCopy } from '@/webPublic/one_stop_public/utils/myutils';
import moment from 'moment';
import { giveSmartFormGlobalProps } from '@/webPublic/one_stop_public/Table/giveSmartFormGlobalProps';
import { getToken, getUserInfo } from '@/webPublic/one_stop_public/utils/token';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';

const test = getUrlInfo().test;

export default function prepareShow(postData = {}, content = '', otherParams = { fromStart: false }) {
  // 模板挂载前执行的公式

  giveSmartFormGlobalProps({
    data: postData || content,
    ...otherParams,
  });
  if (process.env.NODE_ENV === 'development') {
    // console.log(window.smartFormGlobalProps.data);
  }
  let agg = deepCopy(postData);
  window.beforeApplySubmit = undefined; // 流程发起时执行的异步回调函数 这里清空 防止泄露
  window.beforeAuditSubmit = undefined; // 流程审批时执行的异步回调函数 这里清空 防止泄露
  window.callbackApplyDataInfoZhiYong = undefined; // 流程发起时执行的同步函数 这里清空 防止泄露
  window.callbackSubmitInfoZhiYong = undefined; // 流程审批时执行的回调函数 这里清空 防止泄露
  window.zdyTableTemplateWillMountProps = true;
  window.message = message;
  window.Modal = Modal;
  window.moment = moment;
  return new Promise((resolve, reject) => {
    console.log(agg?.unifiedServicePatternModel?.id); // 表单id;
    if (agg?.unifiedServicePatternModel?.id && localStorage.getItem('errDetail') === '1') {
      const SystemConfig = window.specialImportantSystemConfig || {};
      console.log('%c' + `${SystemConfig?.gateWayPort}/onestop/#/admin/processServices/modelConfig/templateDetail/designById?id=${agg.unifiedServicePatternModel.id}&token=${getToken()}`, 'color: green;background: white;font-size: 14px');
      console.log('%c' + `${SystemConfig?.gateWayPort}/wisdomYsgz/#/designFormByUrl?id=${agg.unifiedServicePatternModel.id}&token=${getToken()}`, 'color: green;background: white;font-size: 14px');
    }
    let data = agg?.unifiedServicePatternModel?.content || content;
    let g = !!data && isJSON(data) && JSON.parse(data)?.templateWillMount;
    if (g && typeof g === 'string' && g.length > 10) {
      let p = {
        // 函数参数
        message,
        Modal,
        uaaRequest,
        userNowInfo:
          (isJSON(localStorage.getItem('user')) && JSON.parse(localStorage.getItem('user'))) || {},
        templateData: agg,
      };

      let newFunc = new Function('props', g);
      console.log('开始执行templateWillMount公式');
      try {
        newFunc(p) // 返回一个promise
          .then(res => {
            if (res) {
              // console.log('执行templateWillMount公式完成', res);
              window.zdyTableTemplateWillMountProps = res;
              resolve(true);
            }
          })
          .catch(error => {
            window.zdyTableTemplateWillMountProps = undefined;
            resolve(true);
            console.log('模板挂载时公式执行失败', error);
          });
      } catch (e) {
        resolve(true);
        console.log(e);
      }
    } else {
      resolve(true);
    }
  });
}


