/**
 * A specialized version of `forEach` for arrays.
 *  数组的“forEach”的专门版本。
 * @private
 * @param {Array} [array] 要遍历的数组。
 * @param {Function} iteratee 每次迭代调用的函数。
 * @returns {Array} 返回的数组
 */
function arrayEach(array, iteratee) {
	let index = -1;
	const length = array.length;

	while (++index < length) {
		if (iteratee(array[index], index, array) === false) {
			break;
		}
	}
	return array;
}

export default arrayEach;
