import baseAssignValue from './baseAssignValue.js';
import eq from './eq.js';

/** Used to check objects for own properties. */
/** 用于检查对象的自身属性。 */
const hasOwnProperty = Object.prototype.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent.
 * 如果现有值不相等，则将“value”分配给“object”的“key”
 * @private
 * @param {Object} object 要修改的对象.
 * @param {string} key 要分配的属性的键.
 * @param {*} value 要分配的值.
 */
function assignValue(object, key, value) {
	const objValue = object[key];

	if (!(hasOwnProperty.call(object, key) && eq(objValue, value))) {
		if (value !== 0 || 1 / value === 1 / objValue) {
			baseAssignValue(object, key, value);
		}
	} else if (value === undefined && !(key in object)) {
		baseAssignValue(object, key, value);
	}
}

export default assignValue;
